/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;

@Mixin(value={TileEntityWareHouse.class}, remap=false)
public abstract class TileEntityWareHouseMixin
extends AbstractTileEntityWareHouse {
    public TileEntityWareHouseMixin(BlockEntityType<? extends AbstractTileEntityWareHouse> warehouse, BlockPos pos, BlockState state) {
        super(warehouse, pos, state);
    }

    @Inject(method={"hasMatchingItemStackInWarehouse(Lnet/minecraft/world/item/ItemStack;IZZI)Z"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    public void hasMatchingItemStackInWarehouse(ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver, CallbackInfoReturnable<Boolean> cir) {
        NetworkStorageModule module = (NetworkStorageModule)this.getBuilding().getModule(ModBuildingModules.NETWORK_STORAGE);
        if (module != null && module.hasMatchingItemStack(itemStack, count, ignoreNBT, ignoreDamage, leftOver)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"dumpInventoryIntoWareHouse"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void dumpInventoryIntoWareHouse(InventoryCitizen inventoryCitizen, CallbackInfo ci) {
        NetworkStorageModule module = (NetworkStorageModule)this.getBuilding().getModule(ModBuildingModules.NETWORK_STORAGE);
        if (module != null) {
            module.dump((IItemHandlerModifiable)inventoryCitizen);
        }
    }
}

