/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingTemplateRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class SmithingTemplateCraftingModule
extends AbstractCraftingBuildingModule.Crafting
implements IBuildingEventsModule {
    public static final int INVENTORY_SLOTS = 27;
    public static final String TAG_INVENTORY = "inventory";
    private final ItemStackHandler inventory = new ItemStackHandler(27){

        public boolean isItemValid(int slot, ItemStack stack) {
            return ItemStackHelper.isSmithingTemplate(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SmithingTemplateCraftingModule.this.onSlotChanged(slot);
        }
    };
    private final ItemStackCounter counter = new ItemStackCounter();

    public SmithingTemplateCraftingModule(JobEntry jobEntry) {
        super(jobEntry);
        this.counter.addListener(this::onCounterChanged);
    }

    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
    }

    public void refreshCounter() {
        ItemStackCounter newCounter = new ItemStackCounter();
        int sizeslots = this.inventory.getSlots();
        for (int i = 0; i < sizeslots; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            newCounter.insert(new ItemStackKey(stack), stack.m_41613_());
        }
        this.counter.replace((Iterable<Object2LongMap.Entry<ItemStackKey>>)newCounter.entrySet());
    }

    public void onSlotChanged(int index) {
        this.markDirty();
        this.refreshCounter();
    }

    @NotNull
    public String getId() {
        return "smithing_template_crafting";
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.inventory.deserializeNBT(compound.m_128469_(TAG_INVENTORY));
        this.refreshCounter();
    }

    public void serializeNBT(@NotNull CompoundTag compound) {
        super.serializeNBT(compound);
        compound.m_128365_(TAG_INVENTORY, (Tag)this.inventory.serializeNBT());
    }

    public void serializeToView(@NotNull FriendlyByteBuf buf, boolean fullSync) {
        super.serializeToView(buf, fullSync);
        this.counter.serializeBuffer(buf);
    }

    public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
        return ItemStackHelper.isSmithingTemplate(recipe.getPrimaryOutput()) && super.isRecipeCompatible(recipe);
    }

    public boolean holdsRecipe(IToken<?> token) {
        CustomizableRecipeStorage crs;
        ICustomizedRecipeStorage iCustomizedRecipeStorage;
        if (!super.holdsRecipe(token)) {
            return false;
        }
        IRecipeManager recipeManager = IMinecoloniesAPI.getInstance().getColonyManager().getRecipeManager();
        IRecipeStorage storage = recipeManager.getRecipe(token);
        if (storage instanceof CustomizableRecipeStorage && (iCustomizedRecipeStorage = (crs = (CustomizableRecipeStorage)storage).getImpl()) instanceof SmithingTemplateRecipeStorage) {
            SmithingTemplateRecipeStorage recipe = (SmithingTemplateRecipeStorage)iCustomizedRecipeStorage;
            long count = this.counter.get(new ItemStackKey(recipe.getPrimaryOutput()));
            return count >= (long)recipe.getInputTemplateCount();
        }
        return true;
    }

    protected void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            ItemStack stack = key.getStack(newCount);
            this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                IDeliverable deliverable;
                IRequestable patt4553$temp = request.getRequest();
                return patt4553$temp instanceof IDeliverable && (deliverable = (IDeliverable)patt4553$temp).matches(stack);
            });
        }
    }

    public void onDestroyed() {
        BlockPos pos = this.building.getID();
        InventoryUtils.dropItemHandler((IItemHandler)this.inventory, (Level)this.building.getColony().getWorld(), (int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }
}

