/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.IngredientStack;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;

public class ToolOrIngredientStack {
    public static final ToolOrIngredientStack EMPTY = ToolOrIngredientStack.of(Ingredient.f_43901_);
    private final boolean isToolType;
    @NotNull
    private final EquipmentTypeEntry toolType;
    @NotNull
    private final IngredientStack stack;
    private final boolean isEmpty;

    public ToolOrIngredientStack(boolean isToolType, @NotNull EquipmentTypeEntry toolType, @NotNull IngredientStack stack) {
        this.isToolType = isToolType;
        this.toolType = toolType;
        this.stack = stack;
        this.isEmpty = isToolType ? toolType == ModEquipmentTypes.none.get() : stack.isEmpty();
    }

    public boolean isToolType() {
        return this.isToolType;
    }

    @NotNull
    public EquipmentTypeEntry toolType() {
        return this.toolType;
    }

    @NotNull
    public IngredientStack stack() {
        return this.stack;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean testType(@NotNull ItemStack item) {
        return this.isToolType ? ItemStackHelper.isTool(item, this.toolType) : this.stack.testType(item);
    }

    public int hashCode() {
        return this.isToolType ? this.toolType.hashCode() : this.stack.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ToolOrIngredientStack) {
            ToolOrIngredientStack other = (ToolOrIngredientStack)object;
            if (this.isToolType != other.isToolType) {
                return false;
            }
            if (this.isToolType) {
                return this.toolType == other.toolType;
            }
            return this.stack.equals(other.stack);
        }
        return false;
    }

    @NotNull
    public static ToolOrIngredientStack of(@NotNull CustomToolType toolType) {
        return ToolOrIngredientStack.of(toolType.getToolType());
    }

    @NotNull
    public static ToolOrIngredientStack of(@NotNull EquipmentTypeEntry toolType) {
        return new ToolOrIngredientStack(true, toolType, IngredientStack.EMPTY);
    }

    @NotNull
    public static ToolOrIngredientStack of(@NotNull Ingredient ingredient) {
        return new ToolOrIngredientStack(false, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), IngredientStack.of(ingredient));
    }

    @NotNull
    public static ToolOrIngredientStack of(@NotNull Ingredient ingredient, int count) {
        return new ToolOrIngredientStack(false, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), IngredientStack.of(ingredient, count));
    }
}

