/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class IngredientStack {
    public static final IngredientStack EMPTY = IngredientStack.of(Ingredient.f_43901_, 0);
    @NotNull
    private final Ingredient ingredient;
    private final int count;
    private final boolean isEmpty;

    @NotNull
    public static IngredientStack of(@NotNull Ingredient ingredient) {
        return IngredientStack.of(ingredient, 1);
    }

    @NotNull
    public static IngredientStack of(@NotNull Ingredient ingredient, int count) {
        return new IngredientStack(ingredient, count);
    }

    public IngredientStack(@NotNull Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = ingredient.m_43947_() ? 0 : Math.max(count, 0);
        this.isEmpty = ingredient.m_43947_() || count <= 0;
    }

    public boolean testType(@NotNull ItemStack item) {
        return this.ingredient.test(item);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient.m_43931_().hashCode(), this.count);
    }

    public boolean equals(Object object) {
        if (object instanceof IngredientStack) {
            IngredientStack other = (IngredientStack)object;
            return this.ingredient.m_43931_().equals(other.ingredient.m_43931_()) && this.count == other.count;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @NotNull
    public Ingredient ingredient() {
        return this.ingredient;
    }

    public int count() {
        return this.count;
    }
}

