/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.common.events;

import com.black_dog20.servertabinfo.Config;
import com.black_dog20.servertabinfo.common.network.PacketHandler;
import com.black_dog20.servertabinfo.common.network.packets.PacketDimensions;
import com.black_dog20.servertabinfo.common.network.packets.PacketPlayers;
import com.black_dog20.servertabinfo.common.utils.Dimension;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="servertabinfo")
public class ServerEvents {
    private static List<Dimension> DIMENSIONS = new LinkedList<Dimension>();
    private static Map<UUID, ResourceLocation> PLAYER_DIMENSIONS = new HashMap<UUID, ResourceLocation>();
    private static int ticks = 0;

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6846_().m_11309_() == 0) {
            ticks = 0;
            return;
        }
        if (ticks % (Integer)Config.REFRESH_TICKS.get() == 0) {
            Pair<Integer, Double> overall = ServerEvents.getTpsAndMean(server.f_129748_);
            DIMENSIONS.clear();
            DIMENSIONS.add(new Dimension(new ResourceLocation("servertabinfo", "overall"), (Double)overall.getSecond(), (Integer)overall.getFirst()));
            for (ServerLevel world : server.forgeGetWorldMap().values()) {
                ResourceLocation name = world.m_46472_().m_135782_();
                Pair<Integer, Double> tpsAndMean = ServerEvents.getTpsAndMean(server.getTickTime(world.m_46472_()));
                DIMENSIONS.add(new Dimension(name, (Double)tpsAndMean.getSecond(), (Integer)tpsAndMean.getFirst()));
            }
            List playerList = server.m_6846_().m_11314_();
            PLAYER_DIMENSIONS.clear();
            for (ServerPlayer player : playerList) {
                ResourceLocation name = player.m_20193_().m_46472_().m_135782_();
                PLAYER_DIMENSIONS.put(player.m_20148_(), name);
            }
            PacketHandler.sendToAll(new PacketDimensions(DIMENSIONS));
            PacketHandler.sendToAll(new PacketPlayers(PLAYER_DIMENSIONS));
            ticks = 1;
            return;
        }
        ++ticks;
    }

    private static Pair<Integer, Double> getTpsAndMean(long[] tickArray) {
        long sum = 0L;
        if (tickArray == null) {
            return Pair.of((Object)0, (Object)0.0);
        }
        for (long tickTime : tickArray) {
            sum += tickTime;
        }
        double mean = (double)(sum / (long)tickArray.length) * 1.0E-6;
        int tps = (int)Math.min(1000.0 / mean, 20.0);
        return Pair.of((Object)tps, (Object)mean);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            ResourceLocation name = playerEntity.m_20193_().m_46472_().m_135782_();
            PLAYER_DIMENSIONS.put(playerEntity.m_20148_(), name);
            PacketHandler.sendTo(new PacketDimensions(DIMENSIONS), playerEntity);
            PacketHandler.sendTo(new PacketPlayers(PLAYER_DIMENSIONS), playerEntity);
        }
    }
}

