/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.inf;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class TooltipInfoTexture
implements IRenderableInfo {
    public ResourceLocation texture;
    public float width;
    public float height;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public TooltipInfoTexture(ResourceLocation texture, float width, float height, int rgba) {
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.red = ColorHelper.getRed(rgba);
        this.green = ColorHelper.getGreen(rgba);
        this.blue = ColorHelper.getBlue(rgba);
        this.alpha = ColorHelper.getAlpha(rgba);
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics matrix, float x, float y, float partialTime) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        FXUtils.bindTexture(this.texture);
        RenderUtils.drawTexturedModalRect(matrix.m_280168_(), x, y, null, this.width, this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

