/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;

public interface ITooltipTile {
    public static final ProgressBar[] NO_BARS = new ProgressBar[0];

    default public void getTextTooltip(List<Component> list, Player player) {
    }

    default public boolean isEngineSupported(EnumTooltipEngine engine) {
        return HLConstants.enableHammerLibTooltipEngine || engine != EnumTooltipEngine.HAMMER_LIB;
    }

    default public boolean hasProgressBars(Player player) {
        ProgressBar[] bars = this.getProgressBars(player);
        return bars != null && bars.length > 0;
    }

    default public ProgressBar[] getProgressBars(Player player) {
        return NO_BARS;
    }

    default public boolean hasItemIconOverride() {
        return false;
    }

    default public ItemStack getItemIconOverride() {
        return ItemStack.f_41583_;
    }

    default public void addTooltip(ITooltipConsumer consumer, Player player) {
        ArrayList<Component> tip = new ArrayList<Component>();
        this.getTextTooltip(tip, player);
        for (Component s : tip) {
            consumer.addLine(s);
        }
        if (this.hasProgressBars(player)) {
            for (ProgressBar bar : this.getProgressBars(player)) {
                consumer.addBar(bar);
            }
        }
    }
}

