/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.cc;

import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.zeith.api.blocks.redstone.IRedstoneBundle;
import org.zeith.api.blocks.redstone.IRedstoneBundleAccessor;
import org.zeith.api.blocks.redstone.MCColor;

public class BundledCCCapability
implements ICapabilityProvider {
    public final AbstractComputerBlockEntity computer;
    public final LazyOptional<IRedstoneBundle>[] sidedBundles = (LazyOptional[])Util.m_137469_((Object)new LazyOptional[6], s -> {
        for (Direction side : Direction.values()) {
            s[side.ordinal()] = LazyOptional.of(() -> new ComputerBundleProvider(side));
        }
    });

    public BundledCCCapability(AbstractComputerBlockEntity computer) {
        this.computer = computer;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == IRedstoneBundle.REDSTONE_BUNDLE() && side != null) {
            return this.sidedBundles[side.ordinal()].cast();
        }
        return LazyOptional.empty();
    }

    public class ComputerBundleProvider
    implements IRedstoneBundle {
        public final Direction side;

        public ComputerBundleProvider(Direction side) {
            this.side = side;
        }

        @Override
        public boolean isConnected() {
            Block block = BundledCCCapability.this.computer.m_58900_().m_60734_();
            if (block instanceof IBundledRedstoneBlock) {
                IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
                return blk.getBundledRedstoneConnectivity(BundledCCCapability.this.computer.m_58904_(), BundledCCCapability.this.computer.m_58899_(), this.side);
            }
            return false;
        }

        @Override
        public @Range(from=0L, to=65535L) int getSerializedBundleSignal() {
            Block block = BundledCCCapability.this.computer.m_58900_().m_60734_();
            if (block instanceof IBundledRedstoneBlock) {
                IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
                return blk.getBundledRedstoneOutput(BundledCCCapability.this.computer.m_58904_(), BundledCCCapability.this.computer.m_58899_(), this.side);
            }
            return 0;
        }

        @Override
        public boolean hasSignal(MCColor color) {
            Block block = BundledCCCapability.this.computer.m_58900_().m_60734_();
            if (block instanceof IBundledRedstoneBlock) {
                IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
                int redstone = blk.getBundledRedstoneOutput(BundledCCCapability.this.computer.m_58904_(), BundledCCCapability.this.computer.m_58899_(), this.side);
                return IRedstoneBundleAccessor.hasSerialized(redstone, color);
            }
            return false;
        }

        @Override
        public boolean setSignal(MCColor color, boolean signal) {
            return false;
        }

        @Override
        public boolean setSerializedBundleSignal(@Range(from=0L, to=65535L) int serialized) {
            return false;
        }
    }
}

