/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import java.util.ArrayList;
import java.util.List;
import org.zeith.hammerlib.client.flowgui.MousePos;

public interface RenderHook {
    public static final RenderHook NOOP = (partialTime, mouse) -> {};

    public void hook(float var1, MousePos var2);

    default public RenderHook andThen(RenderHook task) {
        return (partialTime, mouse) -> {
            this.hook(partialTime, mouse);
            task.hook(partialTime, mouse);
        };
    }

    public static RenderHook list() {
        return new ListOf();
    }

    public static class ListOf
    implements RenderHook {
        List<RenderHook> hooks = new ArrayList<RenderHook>();

        @Override
        public void hook(float partialTime, MousePos mouse) {
            for (RenderHook hook : this.hooks) {
                hook.hook(partialTime, mouse);
            }
        }

        @Override
        public RenderHook andThen(RenderHook task) {
            this.hooks.add(task);
            return this;
        }
    }
}

