/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.annotations.ap;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;

public interface IAPContext {
    public static final IAPContext DUMMY = new IAPContext(){};

    default public Optional<ResourceLocation> getRegistryName() {
        return Optional.empty();
    }

    default public boolean shouldRegister() {
        return true;
    }

    default public Optional<FMLModContainer> getOwnerMod() {
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected Optional<ResourceLocation> id = Optional.empty();
        protected Optional<FMLModContainer> ownerMod = Optional.empty();
        protected boolean shouldRegister = true;

        public Builder id(ResourceLocation id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder owner(FMLModContainer mod) {
            this.ownerMod = Optional.ofNullable(mod);
            return this;
        }

        public Builder shouldRegister(boolean shouldRegister) {
            this.shouldRegister = shouldRegister;
            return this;
        }

        public IAPContext build() {
            return new IAPContext(){

                @Override
                public Optional<ResourceLocation> getRegistryName() {
                    return id;
                }

                @Override
                public boolean shouldRegister() {
                    return shouldRegister;
                }

                @Override
                public Optional<FMLModContainer> getOwnerMod() {
                    return ownerMod;
                }
            };
        }
    }
}

