/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datapack;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.moddingx.libx.datapack.DatapackHelper;
import org.moddingx.libx.util.lazy.LazyValue;

public class LibXPack
extends PathPackResources {
    public static final Map<PackType, PackTypeConfig> PACK_CONFIG = Map.of(PackType.CLIENT_RESOURCES, new PackTypeConfig(PackSource.f_244201_, "libxassets", 15), PackType.SERVER_DATA, new PackTypeConfig(PackSource.f_10527_, "libxdata", 15));
    private final String packId;
    private final PackType type;
    private final LazyValue<IoSupplier<InputStream>> packMcmeta;

    public LibXPack(IModFile mod, PackType type, String packId) {
        super(mod.getFileName() + "/" + packId, true, mod.findResource(new String[]{PACK_CONFIG.get(type).prefix()}));
        this.packId = packId;
        this.type = type;
        this.packMcmeta = new LazyValue<IoSupplier>(() -> {
            Object description = "Dynamic " + type.m_10305_() + ": " + mod.getFileName() + "/" + packId;
            try {
                Path descPath = this.getSource().resolve(this.packId).resolve("description.txt");
                if (Files.isRegularFile(descPath, new LinkOption[0])) {
                    description = Files.readString(descPath, StandardCharsets.UTF_8).strip();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return DatapackHelper.generatePackMeta(mod, (String)description, type);
        });
    }

    public IoSupplier<InputStream> m_8017_(String ... names) {
        return names[0].equals("pack.mcmeta") ? this.packMcmeta.get() : super.m_8017_(names);
    }

    public boolean isHidden() {
        return this.type == PackType.SERVER_DATA;
    }

    @Nonnull
    protected Path resolve(String ... pathParts) {
        String[] paths;
        String pathStr = switch (pathParts.length) {
            case 0 -> "";
            case 1 -> pathParts[0];
            default -> {
                StringBuilder sb = new StringBuilder();
                for (String pathPart : pathParts) {
                    sb.append("/").append(pathPart);
                }
                yield sb.toString();
            }
        };
        while (pathStr.contains("//")) {
            pathStr = pathStr.replace("//", "/");
        }
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        if (pathStr.endsWith("/")) {
            pathStr = pathStr.substring(0, pathStr.length() - 1);
        }
        if ((paths = pathStr.split("/")).length == 0) {
            return this.getSource().resolve(this.packId);
        }
        Path path = switch (paths[0]) {
            case "pack.mcmeta" -> this.getSource();
            case "pack.png" -> this.getSource().resolve(this.packId).resolve("pack.png");
            default -> this.type.m_10305_().equals(paths[0]) ? this.getSource().resolve(this.packId) : this.getSource().resolve(this.packId).resolve("SNOWBALL");
        };
        for (int i = 1; i < paths.length; ++i) {
            path = path.resolve(paths[i]);
        }
        return path;
    }

    public record PackTypeConfig(PackSource source, String prefix, int version) {
    }
}

