/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.editor;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.render.RenderHelper;

public class InputEditor<T>
implements ConfigEditor<T> {
    private final InputProperties<T> properties;
    private final ValidatorInfo<?> validator;

    public InputEditor(InputProperties<T> properties, ValidatorInfo<?> validator) {
        this.properties = properties;
        this.validator = validator;
    }

    @Override
    public T defaultValue() {
        return this.properties.defaultValue();
    }

    @Override
    public AbstractWidget createWidget(Screen screen, T initialValue, WidgetProperties<T> properties) {
        return new InputWidget<T>(this.properties, this.validator, initialValue, properties);
    }

    @Override
    public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<T> properties) {
        if (old instanceof InputWidget) {
            return new InputWidget<T>(this.properties, this.validator, (InputWidget)old, properties);
        }
        return this.createWidget(screen, this.defaultValue(), properties);
    }

    public static class InputWidget<T>
    extends EditBox {
        private final InputProperties<T> input;
        private final ValidatorInfo<?> validator;
        private String last = null;

        private InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, WidgetProperties<T> properties, String initialValue) {
            super(Minecraft.m_91087_().f_91062_, properties.x(), properties.y(), properties.width(), properties.height(), (Component)Component.m_237119_());
            this.input = input;
            this.validator = validator;
            this.m_94199_(Short.MAX_VALUE);
            this.m_94144_(initialValue);
            this.m_94153_(str -> {
                for (char chr : str.toCharArray()) {
                    if (this.input.canInputChar(chr)) continue;
                    return false;
                }
                return true;
            });
            this.m_94151_(str -> {
                if (this.last == null || !this.last.equals(str)) {
                    this.last = str;
                    if (this.input.isValid((String)str)) {
                        properties.inputChanged().accept(this.input.valueOf((String)str));
                    }
                }
            });
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, T initialValue, WidgetProperties<T> properties) {
            this(input, validator, properties, input.toString(initialValue));
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, InputWidget<T> old, WidgetProperties<T> properties) {
            this(input, validator, properties, old.m_94155_());
        }

        public Optional<T> getValidInput() {
            return this.getValidInput(this.m_94155_());
        }

        private Optional<T> getValidInput(String str) {
            T t;
            if (this.input.isValid(str) && this.validator.isValid(t = this.input.valueOf(str))) {
                return Optional.of(t);
            }
            return Optional.empty();
        }

        public void m_87963_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.m_87963_(graphics, mouseX, mouseY, partialTicks);
            if (this.m_94213_() && this.getValidInput(this.m_94155_()).isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
                RenderHelper.rgb(0xFF2222);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() - 1, 0.0f, 0.0f, this.f_93618_ + 2, 1, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() + this.f_93619_, 0.0f, 0.0f, this.f_93618_ + 2, 1, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() - 1, 0.0f, 0.0f, 1, this.f_93619_ + 2, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() + this.f_93618_, this.m_252907_() - 1, 0.0f, 0.0f, 1, this.f_93619_ + 2, 256, 256);
                RenderHelper.resetColor();
                graphics.m_280168_().m_85849_();
            }
        }
    }
}

