/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.codec.Param;
import org.moddingx.libx.annotation.codec.PrimaryConstructor;
import org.moddingx.libx.annotation.config.RegisterConfig;
import org.moddingx.libx.annotation.config.RegisterMapper;
import org.moddingx.libx.annotation.model.Model;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.Processor;
import org.moddingx.libx.annotation.processor.modinit.FailureException;
import org.moddingx.libx.annotation.processor.modinit.ModEnv;
import org.moddingx.libx.annotation.processor.modinit.ModInit;
import org.moddingx.libx.annotation.processor.modinit.codec.CodecProcessor;
import org.moddingx.libx.annotation.processor.modinit.config.RegisterConfigProcessor;
import org.moddingx.libx.annotation.processor.modinit.config.RegisterMapperProcessor;
import org.moddingx.libx.annotation.processor.modinit.model.ModelProcessor;
import org.moddingx.libx.annotation.processor.modinit.register.RegisterClassProcessor;
import org.moddingx.libx.annotation.registration.RegisterClass;

public class ModInitProcessor
extends Processor
implements ModEnv {
    private final Map<String, ModInit> modInits = new HashMap<String, ModInit>();
    private String defaultModid = null;
    private Element defaultMod = null;

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{RegisterClass.class, Model.class, RegisterConfig.class, RegisterMapper.class, PrimaryConstructor.class, Param.class};
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add(Classes.sourceName("net.minecraftforge.fml.common.Mod"));
        set.add(Classes.sourceName("org.moddingx.libx.annotation.ForMod"));
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.modInits.clear();
        this.defaultModid = null;
        this.defaultMod = null;
        TypeElement modAnnotation = this.typeElement("net.minecraftforge.fml.common.Mod");
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(modAnnotation);
        if (set.size() == 1) {
            Element elem = set.iterator().next();
            String modid = this.modidFromAnnotation(set.iterator().next());
            if (modid != null) {
                this.defaultModid = modid;
                this.defaultMod = elem;
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterClass.class)) {
            try {
                RegisterClassProcessor.processRegisterClass(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Model.class)) {
            try {
                ModelProcessor.processModel(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterMapper.class)) {
            try {
                RegisterMapperProcessor.processRegisterMapper(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterConfig.class)) {
            try {
                RegisterConfigProcessor.processRegisterConfig(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Param.class)) {
            try {
                CodecProcessor.processAnyParam(element, "Param", this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PrimaryConstructor.class)) {
            try {
                CodecProcessor.processPrimaryConstructor(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (ModInit modInit : this.modInits.values()) {
            modInit.write(this.filer(), this.messager());
        }
    }

    @Override
    public ModInit getMod(Element element) {
        return this.getMod(element, element);
    }

    private ModInit getMod(Element element, Element root) {
        PackageElement pkgElem;
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!this.sameErasure(annotationMirror.getAnnotationType().asElement().asType(), this.forClass("org.moddingx.libx.annotation.ForMod"))) continue;
            Object typeValue = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                typeValue = entry.getValue().getValue();
                break;
            }
            if (typeValue == null) {
                throw new IllegalStateException("Invalid @ForMod annotation: No value set.");
            }
            if (!(typeValue instanceof TypeMirror)) {
                throw new IllegalStateException("Invalid @ForMod annotation: Value is not a type.");
            }
            TypeMirror modClass = (TypeMirror)typeValue;
            String modid = this.modidFromAnnotation(this.types().asElement(modClass));
            if (modid == null) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Class used in @ForMod is not annotated with @Mod");
            }
            if (!this.modInits.containsKey(modid)) {
                this.modInits.put(modid, new ModInit(modid, this.types().asElement(modClass), this.messager()));
            }
            return this.modInits.get(modid);
        }
        if (element.getEnclosingElement() != null) {
            return this.getMod(element.getEnclosingElement(), root);
        }
        if (element instanceof PackageElement && !(pkgElem = (PackageElement)element).isUnnamed()) {
            String string = pkgElem.getQualifiedName().toString();
            if (!string.contains(".")) {
                return this.getMod(this.elements().getPackageElement(""), root);
            }
            return this.getMod(this.elements().getPackageElement(string.substring(0, string.lastIndexOf(46))), root);
        }
        if (this.defaultModid != null && this.defaultMod != null) {
            if (!this.modInits.containsKey(this.defaultModid)) {
                this.modInits.put(this.defaultModid, new ModInit(this.defaultModid, this.defaultMod, this.messager()));
            }
            return this.modInits.get(this.defaultModid);
        }
        this.messager().printMessage(Diagnostic.Kind.ERROR, "Could not infer modid for element. Use an @ForMod annotation.", root);
        return new ModInit("", this.typeElement("org.moddingx.libx.mod.ModX"), this.messager());
    }

    private String modidFromAnnotation(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.sameErasure(this.forClass("net.minecraftforge.fml.common.Mod"), annotationMirror.getAnnotationType())) continue;
            return annotationMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).findFirst().map(Map.Entry::getValue).map(v -> v.getValue().toString()).get();
        }
        return null;
    }
}

