/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.util.cooldowns;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SummonerItemCooldowns {
    private final Map<ItemStack, SummonerCooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public static SummonerItemCooldowns createSummonerItemCooldowns() {
        return new SummonerItemCooldowns();
    }

    public boolean isOnCooldown(ItemStack itemStack) {
        return this.getCooldownPercent(itemStack, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(ItemStack itemStack, float f) {
        SummonerCooldownInstance CooldownInstance = this.cooldowns.get(itemStack);
        if (CooldownInstance != null) {
            float g = CooldownInstance.endTime - CooldownInstance.startTime;
            float h = (float)CooldownInstance.endTime - ((float)this.tickCount + f);
            return Mth.m_14036_((float)(h / g), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<ItemStack, SummonerCooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, SummonerCooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey());
            }
        }
    }

    public void addCooldown(ItemStack itemStack, int i) {
        this.cooldowns.put(itemStack, new SummonerCooldownInstance(this.tickCount, this.tickCount + i));
        this.onCooldownStarted(itemStack, i);
    }

    public void removeCooldown(ItemStack itemStack) {
        this.cooldowns.remove(itemStack);
        this.onCooldownEnded(itemStack);
    }

    protected void onCooldownStarted(ItemStack itemStack, int i) {
    }

    protected void onCooldownEnded(ItemStack itemStack) {
    }

    static class SummonerCooldownInstance {
        final int startTime;
        final int endTime;

        SummonerCooldownInstance(int i, int j) {
            this.startTime = i;
            this.endTime = j;
        }
    }
}

