/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.util;

import com.github.teamfusion.summonerscrolls.common.config.ConfigEntries;
import com.github.teamfusion.summonerscrolls.common.item.ScrollItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;

public class ScrollUtil {
    public static EntityType<?> getEntityType(CompoundTag nbt) {
        return (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(nbt.m_128461_("summon")));
    }

    public static int getEntityCount(CompoundTag nbt) {
        return nbt.m_128451_("count");
    }

    public static int getCost(CompoundTag nbt) {
        return nbt.m_128451_("cost");
    }

    public static int getDamage(CompoundTag nbt) {
        return nbt.m_128451_("damageAmount");
    }

    public static boolean hasScrollProperties(CompoundTag nbt) {
        return nbt.m_128441_("summon") && nbt.m_128441_("count") && nbt.m_128441_("cost") && nbt.m_128441_("damageAmount");
    }

    public static void removeScrollFromItem(ItemStack stack) {
        Item enhancedItem = stack.m_41720_();
        if (enhancedItem instanceof TieredItem) {
            stack.m_41749_("summon");
            stack.m_41749_("count");
            stack.m_41749_("cost");
            stack.m_41749_("damageAmount");
            CompoundTag displayTag = stack.m_41698_("display");
            ListTag loreList = displayTag.m_128437_("Lore", 8);
            loreList.remove(loreList.size() - 1);
            loreList.remove(loreList.size() - 1);
            stack.m_41700_("Lore", (Tag)loreList);
        }
    }

    public static boolean applyScrollToItemInAnvil(AnvilMenu container, ItemStack left, ItemStack right, Container outputSlot, String name) {
        Item leftItem = left.m_41720_();
        Item rightItem = right.m_41720_();
        CompoundTag leftNbt = left.m_41784_();
        if (rightItem instanceof ScrollItem && !ScrollUtil.hasScrollProperties(leftNbt)) {
            if (leftItem instanceof TieredItem) {
                ItemStack copy = left.m_41777_();
                CompoundTag scrollTag = right.m_41783_();
                if (scrollTag != null) {
                    CompoundTag resultTag = copy.m_41784_();
                    resultTag.m_128391_(scrollTag);
                    CompoundTag displayTag = copy.m_41698_("display");
                    ListTag lore = new ListTag();
                    if (resultTag.m_128451_("count") <= 1) {
                        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.summonerscrolls.summoner_scroll_desc_a", (Object[])new Object[]{ScrollUtil.getEntityType(resultTag).m_20676_()}))));
                    } else {
                        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.summonerscrolls.summoner_scroll_desc_b", (Object[])new Object[]{resultTag.m_128451_("count"), ScrollUtil.getEntityType(resultTag).m_20676_()}))));
                    }
                    lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.summonerscrolls.summoner_scroll_desc_c", (Object[])new Object[]{resultTag.m_128451_("cost")}).m_130940_(ChatFormatting.GREEN))));
                    displayTag.m_128365_("Lore", (Tag)lore);
                }
                if (name != null && !name.isEmpty()) {
                    copy.m_41714_((Component)Component.m_237113_((String)name));
                }
                outputSlot.m_6836_(0, copy);
                container.f_39002_.m_6422_(ConfigEntries.anvilXPCost);
                return false;
            }
            return false;
        }
        return true;
    }
}

