/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.registry;

import com.github.teamfusion.summonerscrolls.common.config.ConfigEntries;
import com.github.teamfusion.summonerscrolls.common.config.ConfigEntry;
import com.github.teamfusion.summonerscrolls.common.entity.SummonerEntityTypes;
import com.github.teamfusion.summonerscrolls.common.item.ScrollItem;
import com.github.teamfusion.summonerscrolls.common.item.SummonerArrow;
import com.github.teamfusion.summonerscrolls.common.item.SummonerBowItem;
import com.github.teamfusion.summonerscrolls.common.item.SummonerCrossBow;
import com.github.teamfusion.summonerscrolls.common.item.SummonerTiers;
import com.github.teamfusion.summonerscrolls.platform.CoreRegistry;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class SummonerItems {
    public static final CoreRegistry<Item> ITEMS = CoreRegistry.create(BuiltInRegistries.f_257033_, "summonerscrolls");
    public static final Supplier<Item> ZOMBIE_SCROLL = SummonerItems.regScroll("zombie", SummonerEntityTypes.ZOMBIE_SUMMON, ConfigEntries.zombie);
    public static final Supplier<Item> SPIDER_SCROLL = SummonerItems.regScroll("spider", SummonerEntityTypes.SPIDER_SUMMON, ConfigEntries.spider);
    public static final Supplier<Item> SPIDER_JOCKEY_SCROLL = SummonerItems.regScroll("spider_jockey", SummonerEntityTypes.SPIDER_JOCKEY_SUMMON, ConfigEntries.spiderJockey);
    public static final Supplier<Item> SKELETON_SCROLL = SummonerItems.regScroll("skeleton", SummonerEntityTypes.SKELETON_SUMMON, ConfigEntries.skeleton);
    public static final Supplier<Item> BEE_SCROLL = SummonerItems.regScroll("bee", 5, SummonerEntityTypes.BEE_SUMMON, ConfigEntries.bee);
    public static final Supplier<Item> HUSK_SCROLL = SummonerItems.regScroll("husk", SummonerEntityTypes.HUSK_SUMMON, ConfigEntries.husk);
    public static final Supplier<Item> STRAY_SCROLL = SummonerItems.regScroll("stray", SummonerEntityTypes.STRAY_SUMMON, ConfigEntries.stray);
    public static final Supplier<Item> CAVE_SPIDER_SCROLL = SummonerItems.regScroll("cave_spider", 3, SummonerEntityTypes.CAVE_SPIDER_SUMMON, ConfigEntries.caveSpider);
    public static final Supplier<Item> ENDERMAN_SCROLL = SummonerItems.regScroll("enderman", SummonerEntityTypes.ENDERMAN_SUMMON, ConfigEntries.enderman);
    public static final Supplier<Item> PIGLIN_SCROLL = SummonerItems.regScroll("piglin", SummonerEntityTypes.PIGLIN_SUMMON, ConfigEntries.piglin);
    public static final Supplier<Item> CREEPER_SCROLL = SummonerItems.regScroll("creeper", SummonerEntityTypes.CREEPER_SUMMON, ConfigEntries.creeper);
    public static final Supplier<Item> CHARGED_CREEPER_SCROLL = SummonerItems.regScroll("charged_creeper", SummonerEntityTypes.CHARGED_CREEPER_SUMMON, ConfigEntries.chargedCreeper);
    public static final Supplier<Item> PIGLIN_BRUTE_SCROLL = SummonerItems.regScroll("piglin_brute", SummonerEntityTypes.PIGLIN_BRUTE_SUMMON, ConfigEntries.piglinBrute);
    public static final Supplier<Item> SHULKERMAN_SCROLL = SummonerItems.regScroll("shulkerman", SummonerEntityTypes.SHULKERMAN_SUMMON, ConfigEntries.shulkerman);
    public static final Supplier<Item> IRON_GOLEM_SCROLL = SummonerItems.regScroll("iron_golem", SummonerEntityTypes.IRON_GOLEM_SUMMON, ConfigEntries.ironGolem);
    public static final Supplier<Item> ENHANCEMENT_SCROLL = ITEMS.register("enhancement_scroll", () -> new Item(new Item.Properties().m_41487_(16)));
    public static final Supplier<Item> SUMMON_BOW = ITEMS.register("summon_bow", () -> new SummonerBowItem(new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_CROSSBOW = ITEMS.register("summon_crossbow", () -> new SummonerCrossBow(new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_ARROW = ITEMS.register("summon_arrow", () -> new SummonerArrow(new Item.Properties()));
    public static final Supplier<Item> SUMMON_SWORD = ITEMS.register("summon_sword", () -> new SwordItem((Tier)SummonerTiers.SUMMONER, 3, -2.4f, new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_AXE = ITEMS.register("summon_axe", () -> new AxeItem((Tier)SummonerTiers.SUMMONER, 6.0f, -3.0f, new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_PICKAXE = ITEMS.register("summon_pickaxe", () -> new PickaxeItem((Tier)SummonerTiers.SUMMONER, 1, -2.8f, new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_SHOVEL = ITEMS.register("summon_shovel", () -> new ShovelItem((Tier)SummonerTiers.SUMMONER, 1.5f, -3.0f, new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SUMMON_HOE = ITEMS.register("summon_hoe", () -> new HoeItem((Tier)SummonerTiers.SUMMONER, -2, -3.0f, new Item.Properties().m_41487_(1)));

    private static <T extends Entity> Supplier<Item> regScroll(String key, Supplier<EntityType<T>> entityType, ConfigEntry.Scroll scrollCfg) {
        return SummonerItems.regScroll(key, 1, entityType, scrollCfg);
    }

    private static <T extends Entity> Supplier<Item> regScroll(String key, int entityCount, Supplier<EntityType<T>> entityType, ConfigEntry.Scroll scrollCfg) {
        return SummonerItems.regScroll(key, entityCount, entityType, scrollCfg.xp, scrollCfg.durability);
    }

    private static <T extends Entity> Supplier<Item> regScroll(String key, int entityCount, Supplier<EntityType<T>> entityType, int xp, int damageAmount) {
        return ITEMS.register(key + "_summoner_scroll", () -> new ScrollItem(entityType, entityCount, new Item.Properties().m_41487_(1).m_41503_(8), xp, damageAmount));
    }

    public static void register() {
        ITEMS.register();
    }
}

