/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class AnvilScrollRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    final Ingredient scroll;
    final Ingredient upgrade;
    final ItemStack result;
    final int cost;

    public AnvilScrollRecipe(ResourceLocation id, Ingredient scroll, Ingredient upgrade, ItemStack result, int cost) {
        this.id = id;
        this.scroll = scroll;
        this.upgrade = upgrade;
        this.result = result;
        this.cost = cost;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.scroll.test(container.m_8020_(0)) && this.upgrade.test(container.m_8020_(1));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack itemStack = this.result.m_41777_();
        CompoundTag compoundTag = container.m_8020_(1).m_41783_();
        if (compoundTag != null) {
            itemStack.m_41751_(compoundTag.m_6426_());
        }
        return itemStack;
    }

    public boolean m_8004_(int i, int j) {
        return i >= 2 && j >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilScrollRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "anvil_scroll";

        public AnvilScrollRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"scroll"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"upgrade"));
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            int cost = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"levelcost");
            return new AnvilScrollRecipe(resourceLocation, ingredient, ingredient2, itemStack, cost);
        }

        public AnvilScrollRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            int cost = friendlyByteBuf.readInt();
            return new AnvilScrollRecipe(resourceLocation, ingredient, ingredient2, itemStack, cost);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, AnvilScrollRecipe anvilScrollRecipe) {
            anvilScrollRecipe.scroll.m_43923_(friendlyByteBuf);
            anvilScrollRecipe.upgrade.m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(anvilScrollRecipe.result);
            friendlyByteBuf.writeInt(anvilScrollRecipe.cost);
        }
    }

    public static class Type
    implements RecipeType<AnvilScrollRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "anvil_scroll";

        private Type() {
        }
    }
}

