/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.summons.skeleton;

import com.github.teamfusion.summonerscrolls.common.entity.base.BaseSummonedEntity;
import com.github.teamfusion.summonerscrolls.common.entity.base.goal.SummonerRangedBowAttackGoal;
import com.github.teamfusion.summonerscrolls.common.registry.SummonerItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SkeletonSummon
extends BaseSummonedEntity
implements RangedAttackMob {
    private final SummonerRangedBowAttackGoal<SkeletonSummon> bowGoal = new SummonerRangedBowAttackGoal<SkeletonSummon>(this, 1.0, 20, 15.0f, SummonerItems.SUMMON_BOW.get());
    public final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);

    public SkeletonSummon(EntityType<? extends BaseSummonedEntity> entityType, Level level) {
        super(entityType, level);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SummonerItems.SUMMON_BOW.get()));
        this.reassessWeaponGoal();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    public void reassessWeaponGoal() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemStack = this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)SummonerItems.SUMMON_BOW.get()));
            if (itemStack.m_150930_(SummonerItems.SUMMON_BOW.get())) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.setMinAttackInterval(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_6504_(LivingEntity target, float velocity) {
        this.preformBowAttack(target, velocity, false);
    }

    public void preformBowAttack(LivingEntity target, float velocity, boolean isStray) {
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)SummonerItems.SUMMON_BOW.get())));
        AbstractArrow abstractArrow = this.getArrow(itemStack, velocity);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.3333333333333333) - abstractArrow.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        abstractArrow.m_6686_(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * (isStray ? 8 : 4)));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractArrow);
    }

    protected AbstractArrow getArrow(ItemStack arrowStack, float velocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)velocity);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeapon) {
        return projectileWeapon == SummonerItems.SUMMON_BOW.get();
    }

    public static AttributeSupplier.Builder createSummonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.3).m_22266_(Attributes.f_22287_);
    }
}

