/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.summons.piglin;

import com.github.teamfusion.summonerscrolls.common.entity.base.BaseSummonedEntity;
import com.github.teamfusion.summonerscrolls.common.entity.base.goal.SummonerRangedCrossbowAttack;
import com.github.teamfusion.summonerscrolls.common.registry.SummonerItems;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PiglinSummon
extends BaseSummonedEntity
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(PiglinSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PiglinSummon(EntityType<? extends BaseSummonedEntity> entityType, Level level) {
        super(entityType, level);
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        if (this.m_21205_().m_150930_(SummonerItems.SUMMON_CROSSBOW.get())) {
            this.f_21345_.m_25352_(3, new SummonerRangedCrossbowAttack<PiglinSummon>(this, 1.0, 8.0f));
        } else {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        }
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12244_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12239_;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        super.m_213945_(randomSource, difficultyInstance);
    }

    public ItemStack createSpawnWeapon() {
        return (double)this.f_19796_.m_188501_() < 0.5 ? new ItemStack((ItemLike)SummonerItems.SUMMON_CROSSBOW.get()) : new ItemStack((ItemLike)SummonerItems.SUMMON_SWORD.get());
    }

    public static AttributeSupplier.Builder createSummonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 16.0).m_22266_(Attributes.f_22287_);
    }

    public void m_32336_(LivingEntity livingEntity, float f) {
        InteractionHand interactionHand = ProjectileUtil.m_37297_((LivingEntity)livingEntity, (Item)SummonerItems.SUMMON_CROSSBOW.get());
        ItemStack itemStack = livingEntity.m_21120_(interactionHand);
        if (livingEntity.m_21055_(SummonerItems.SUMMON_CROSSBOW.get())) {
            CrossbowItem.m_40887_((Level)livingEntity.m_9236_(), (LivingEntity)livingEntity, (InteractionHand)interactionHand, (ItemStack)itemStack, (float)f, (float)(14 - livingEntity.m_9236_().m_46791_().m_19028_() * 4));
        }
        this.m_5847_();
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_6136_(boolean bl) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)bl);
    }

    private boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING_CROSSBOW);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public PiglinArmPose getArmPose() {
        if (this.m_5912_() && this.isHoldingMeleeWeapon()) {
            return PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return PiglinArmPose.CROSSBOW_CHARGE;
        }
        return this.m_5912_() && this.m_21055_(SummonerItems.SUMMON_CROSSBOW.get()) ? PiglinArmPose.CROSSBOW_HOLD : PiglinArmPose.DEFAULT;
    }

    protected boolean isHoldingMeleeWeapon() {
        return this.m_21205_().m_41720_() instanceof TieredItem;
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float f) {
        this.m_32322_((LivingEntity)this, livingEntity, projectile, f, 1.6f);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem == SummonerItems.SUMMON_CROSSBOW.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
    }
}

