/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.summons;

import com.github.teamfusion.summonerscrolls.common.entity.base.ISummon;
import com.github.teamfusion.summonerscrolls.common.sound.SummonerSoundEvents;
import java.time.LocalDate;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeSummon
extends Bee
implements ISummon,
NeutralMob {
    private UUID ownerUUID;
    private int despawnDelay;
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BeeSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    protected UUID persistentAngerTarget;

    public BeeSummon(EntityType<? extends Bee> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.commonGoals(this.f_21346_, this.f_21345_);
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    public static AttributeSupplier.Builder createSummonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_).m_22268_(Attributes.f_22280_, 0.8);
    }

    @Override
    public LivingEntity getSummon() {
        return this;
    }

    @Override
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        ISummon summon;
        if (this.isStupid(damageSource)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(damageSource, amount);
        }
        Entity directEntity = damageSource.m_7639_();
        if (directEntity == this.getOwner()) {
            return false;
        }
        if (directEntity instanceof ISummon && (summon = (ISummon)directEntity).getOwner() == this.getOwner()) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    private boolean isStupid(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268671_) || damageSource.m_276093_(DamageTypes.f_268434_) || damageSource.m_276093_(DamageTypes.f_268585_);
    }

    public void m_7334_(Entity entity) {
        if (entity == this.getOwner()) {
            return;
        }
        super.m_7334_(entity);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            this.m_6074_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_5592_() {
        LocalDate today = LocalDate.now();
        boolean aprilFools = today.getMonthValue() == 4 && today.getDayOfMonth() == 1 && today.getYear() != 2025;
        return aprilFools ? SummonerSoundEvents.SUMMON_DEATH_APRIL.get() : SummonerSoundEvents.SUMMON_DEATH.get();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("DespawnDelay", this.despawnDelay);
        if (this.getOwnerUUID() != null) {
            tag.m_128362_("Owner", this.getOwnerUUID());
        }
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = tag.m_128451_("DespawnDelay");
        }
        if (tag.m_128403_("Owner")) {
            uuid = tag.m_128342_("Owner");
        } else {
            String s = tag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    public boolean m_21531_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (--this.despawnDelay <= 0 || this.getOwner() == null) {
            this.m_6074_();
        }
        if (this.f_19797_ % 2 == 0) {
            this.spawnSummonParticles(this.f_19796_, (LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20187_(), this.m_20189_());
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (!this.m_9236_().m_5776_()) {
            int count = 80;
            for (int j = 0; j < count; ++j) {
                Level world = this.m_9236_();
                RandomSource random = world.m_213780_();
                float horizontal = (float)random.m_216339_(-10, 10) * 0.125f;
                float vertical = (float)random.m_216339_(-8, 8) * 0.125f;
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 1, (double)horizontal, (double)vertical, (double)horizontal, 0.0);
            }
        }
        this.m_146870_();
    }

    @Override
    public void setDespawnDelay(int delay) {
        this.despawnDelay = Math.max(1, delay);
    }

    @Override
    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }
}

