/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.base.goal;

import com.github.teamfusion.summonerscrolls.common.entity.base.ISummon;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowOwnerGoal
extends Goal {
    private final Mob summon;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public FollowOwnerGoal(Mob summon, double d, float f, float g, boolean bl) {
        this.summon = summon;
        this.level = summon.m_9236_();
        this.speedModifier = d;
        this.navigation = summon.m_21573_();
        this.startDistance = f;
        this.stopDistance = g;
        this.canFly = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = null;
        Mob mob = this.summon;
        if (mob instanceof ISummon) {
            ISummon summon1 = (ISummon)mob;
            livingEntity = summon1.getOwner();
        }
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (this.summon.m_20280_((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return !(this.summon.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.summon.m_21439_(BlockPathTypes.WATER);
        this.summon.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.summon.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.summon.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.summon.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.summon.m_21523_() && !this.summon.m_20159_()) {
                if (this.summon.m_20280_((Entity)this.owner) >= 144.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockPos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean bl = this.maybeTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (Math.abs((double)i - this.owner.m_20185_()) < 2.0 && Math.abs((double)k - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(i, j, k))) {
            return false;
        }
        this.summon.m_7678_((double)i + 0.5, (double)j, (double)k + 0.5, this.summon.m_146908_(), this.summon.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (blockPathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(blockPos.m_7495_());
        if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos2 = blockPos.m_121996_((Vec3i)this.summon.m_20183_());
        return this.level.m_45756_((Entity)this.summon, this.summon.m_20191_().m_82338_(blockPos2));
    }

    private int randomIntInclusive(int i, int j) {
        return this.summon.m_217043_().m_188503_(j - i + 1) + i;
    }
}

