/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.base;

import com.github.teamfusion.summonerscrolls.client.particle.SummonerScrollsParticles;
import com.github.teamfusion.summonerscrolls.common.entity.base.goal.FollowOwnerGoal;
import com.github.teamfusion.summonerscrolls.common.entity.base.goal.OwnerHurtByTargetGoal;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public interface ISummon {
    @Nullable
    public UUID getOwnerUUID();

    public void setOwnerUUID(UUID var1);

    @Nullable
    public LivingEntity getOwner();

    public LivingEntity getSummon();

    public void setDespawnDelay(int var1);

    public int getDespawnDelay();

    default public void spawnSummonParticles(RandomSource random, LevelAccessor level, double x, double y, double z) {
        this.spawnSummonParticles(random, level, x, y, z, 3.2f, 1.0, 0.5);
    }

    default public void spawnSummonParticles(RandomSource random, LevelAccessor level, double x, double y, double z, float intensity, double intensity2, double intensity3) {
        for (float i = 0.0f; i < (float)Math.PI * 2; i += (float)((double)this.generateBoundedFloat(random, intensity) + intensity3)) {
            if (random.m_188503_(3) != 1) continue;
            level.m_7106_((ParticleOptions)SummonerScrollsParticles.SUMMON_PARTICLE.get(), x + (double)Mth.m_14089_((float)i) * intensity2, y, z + (double)Mth.m_14031_((float)i) * intensity2, 0.0, 0.0, 0.0);
        }
    }

    default public void spawnCoolParticles(RandomSource random, LevelAccessor level, double x, double y, double z) {
        for (float i = 0.0f; i < (float)Math.PI * 2; i += random.m_188501_() + 1.0f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x + (double)Mth.m_14089_((float)i) * 0.5, y, z + (double)Mth.m_14031_((float)i) * 0.5, 0.0, 0.0, 0.0);
        }
    }

    default public float generateBoundedFloat(RandomSource randomSource, float upperBound) {
        float randomFloat = randomSource.m_188501_() * upperBound;
        return randomFloat < upperBound ? randomFloat : Math.nextDown(upperBound);
    }

    default public boolean isEnemy(LivingEntity livingEntity) {
        ISummon summon;
        if (livingEntity instanceof ISummon && (summon = (ISummon)livingEntity).getOwner() == this.getOwner()) {
            return false;
        }
        return livingEntity instanceof Enemy;
    }

    default public boolean isSummonAngryAt(LivingEntity livingEntity) {
        ISummon summon;
        if (!this.getSummon().m_6779_(livingEntity)) {
            return false;
        }
        if (livingEntity instanceof ISummon && (summon = (ISummon)livingEntity).getOwner() != null && summon.getOwner().m_20148_().equals(this.getOwnerUUID())) {
            return false;
        }
        return !livingEntity.m_20148_().equals(this.getOwnerUUID());
    }

    default public void commonGoals(GoalSelector targetSelector, GoalSelector goalSelector) {
        LivingEntity livingEntity = this.getSummon();
        if (livingEntity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)livingEntity;
            targetSelector.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((Mob)mob));
            targetSelector.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Mob.class, 5, false, false, this::isEnemy));
            goalSelector.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal(mob, 1.0));
            targetSelector.m_25352_(3, (Goal)new HurtByTargetGoal(mob, new Class[0]));
            goalSelector.m_25352_(6, (Goal)new FollowOwnerGoal((Mob)mob, 1.0, 10.0f, 2.0f, false));
            goalSelector.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)mob, Player.class, 6.0f));
            goalSelector.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)mob));
            targetSelector.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)mob, true));
        }
    }
}

