/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.config;

import com.github.teamfusion.summonerscrolls.SummonerScrolls;
import com.github.teamfusion.summonerscrolls.common.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry<T> {
    private final List<String> path;
    private final T fallback;

    public ConfigEntry(String path) {
        this(path, null);
    }

    public ConfigEntry(String path, @Nullable T fallback) {
        this.path = List.of(path.split("\\."));
        this.fallback = fallback;
    }

    public T get() {
        return this.get(this.fallback);
    }

    public T get(T fallback) {
        Map next = ModConfig.CONFIG;
        T result = null;
        for (String step : this.path) {
            try {
                next = (Map)next.get(step);
            }
            catch (Exception e) {
                if (Objects.equals(step, this.path.get(this.path.size() - 1))) {
                    result = (T)next.get(step);
                }
                SummonerScrolls.LOGGER.info("Couldn't find config value for path : \"" + String.valueOf(this.path) + "\", defaulting to " + String.valueOf(fallback));
                return fallback;
            }
            if (next != null) continue;
            SummonerScrolls.LOGGER.info("Couldn't find config value for path : \"" + String.valueOf(this.path) + "\", defaulting to " + String.valueOf(fallback));
            return fallback;
        }
        if (fallback instanceof Integer) {
            return (T)Integer.valueOf(Long.valueOf(Math.round(Double.parseDouble(String.valueOf(result)))).intValue());
        }
        if (fallback instanceof Double) {
            return (T)Double.valueOf(String.valueOf(result));
        }
        if (fallback instanceof String) {
            return (T)String.valueOf(result);
        }
        if (fallback instanceof Boolean) {
            return (T)Boolean.valueOf(String.valueOf(result));
        }
        if (fallback instanceof Map) {
            return (T)next;
        }
        if (fallback instanceof List) {
            return result;
        }
        SummonerScrolls.LOGGER.info("Couldn't find config value for path : \"" + String.valueOf(this.path) + "\", defaulting to " + String.valueOf(fallback));
        return fallback;
    }

    public static class Scroll {
        private static List<Scroll> INSTANCES = new ArrayList<Scroll>();
        public String path;
        private final ConfigEntry<Integer> xp_entry;
        private final ConfigEntry<Integer> durability_entry;
        public int xp;
        public int durability;

        public Scroll(String path, int xp, int durability) {
            this.path = path;
            this.xp_entry = new ConfigEntry<Integer>(path + ".xp_cost", xp);
            this.durability_entry = new ConfigEntry<Integer>(path + ".durability_cost", durability);
            this.get();
            INSTANCES.add(this);
        }

        public void get() {
            this.xp = this.xp_entry.get();
            this.durability = this.durability_entry.get();
        }

        public static void reload() {
            for (Scroll scroll : INSTANCES) {
                scroll.get();
            }
        }
    }
}

