/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.structures.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.kismet.structures.KProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class FullBlockStateLootProcessor
extends StructureProcessor {
    public static final Codec<FullBlockStateLootProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("output_block").forGetter(config -> config.outputBlock), (App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(c -> c.lootTable)).apply((Applicative)instance, instance.stable(FullBlockStateLootProcessor::new)));
    private final Block inputBlock;
    private final Block outputBlock;
    private final ResourceLocation lootTable;

    public FullBlockStateLootProcessor(Block inputBlock, Block outputBlock, ResourceLocation lootTable) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.lootTable = lootTable;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (infoIn2.f_74676_().m_60734_() == this.inputBlock) {
            BlockState newBlockState = this.outputBlock.m_49966_();
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            long lootTableSeed = random.m_188505_();
            infoIn2.f_74677_().m_128359_("LootTable", this.lootTable.toString());
            if (lootTableSeed != 0L) {
                infoIn2.f_74677_().m_128356_("LootTableSeed", lootTableSeed);
            }
            newBlockState = FullBlockStateLootProcessor.copyBlockProperties(infoIn2.f_74676_(), this.outputBlock.m_49966_());
            return new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_(), newBlockState, infoIn2.f_74677_());
        }
        return infoIn2;
    }

    public static BlockState copyBlockProperties(BlockState oldBlockState, BlockState newBlockState) {
        for (Property property : oldBlockState.m_61147_()) {
            if (!newBlockState.m_61138_(property)) continue;
            newBlockState = FullBlockStateLootProcessor.getStateWithProperty(newBlockState, oldBlockState, property);
        }
        return newBlockState;
    }

    public static <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.m_61124_(property, stateToCopy.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)KProcessors.FULL_STATE_LOOT_PROCESSOR.get();
    }
}

