/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class SimpleChargingRecipeSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final CookieBaker<T> factory;

    public SimpleChargingRecipeSerializer(CookieBaker<T> pFactory, int pDefaultCookingTime) {
        this.defaultCookingTime = pDefaultCookingTime;
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        ItemStack itemstack;
        String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        CookingBookCategory cookingbookcategory = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", (String)null), (Enum)CookingBookCategory.MISC);
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
        if (!pJson.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (pJson.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        } else {
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
        int i = GsonHelper.m_13824_((JsonObject)pJson, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(pRecipeId, s, cookingbookcategory, ingredient, itemstack, f, i);
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String s = pBuffer.m_130277_();
        CookingBookCategory cookingbookcategory = (CookingBookCategory)pBuffer.m_130066_(CookingBookCategory.class);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        ItemStack itemstack = pBuffer.m_130267_();
        float f = pBuffer.readFloat();
        int i = pBuffer.m_130242_();
        return this.factory.create(pRecipeId, s, cookingbookcategory, ingredient, itemstack, f, i);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.m_130068_((Enum)pRecipe.m_245534_());
        ((AbstractCookingRecipe)pRecipe).f_43729_.m_43923_(pBuffer);
        pBuffer.m_130055_(pRecipe.m_8043_(null));
        pBuffer.writeFloat(pRecipe.m_43750_());
        pBuffer.m_130130_(pRecipe.m_43753_());
    }

    public static interface CookieBaker<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, CookingBookCategory var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

