/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.kismet.particles.ElectricChargeParticleType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class ElectricChargeTarget {
    private final ElectricChargeParticleType.TargetType type;
    private final int entityId;
    private final Vec3 position;
    private final List<Integer> chainTargets;
    public static final Codec<ElectricChargeTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ElectricChargeParticleType.TargetType.CODEC.fieldOf("type").forGetter(ElectricChargeTarget::type), (App)Codec.INT.fieldOf("target_entity_id").forGetter(ElectricChargeTarget::entityId), (App)Vec3.f_231074_.fieldOf("position").forGetter(ElectricChargeTarget::position), (App)Codec.INT.listOf().fieldOf("chain_targets").forGetter(ElectricChargeTarget::chainTargets)).apply((Applicative)instance, ElectricChargeTarget::new));

    public ElectricChargeTarget(ElectricChargeParticleType.TargetType type, int entityId, Vec3 position, List<Integer> chainTargets) {
        this.type = type;
        this.entityId = entityId;
        this.position = position;
        this.chainTargets = chainTargets;
    }

    public ElectricChargeParticleType.TargetType type() {
        return this.type;
    }

    public int entityId() {
        return this.entityId;
    }

    public Vec3 position() {
        return this.position;
    }

    public List<Integer> chainTargets() {
        return this.chainTargets;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_130130_(this.entityId);
        buf.writeDouble(this.position.f_82479_);
        buf.writeDouble(this.position.f_82480_);
        buf.writeDouble(this.position.f_82481_);
        buf.m_130130_(this.chainTargets.size());
        for (int id : this.chainTargets) {
            buf.m_130130_(id);
        }
    }

    public static ElectricChargeTarget read(FriendlyByteBuf buf) {
        ElectricChargeParticleType.TargetType type = (ElectricChargeParticleType.TargetType)buf.m_130066_(ElectricChargeParticleType.TargetType.class);
        int entityId = buf.m_130242_();
        Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int chainSize = buf.m_130242_();
        ArrayList<Integer> chain = new ArrayList<Integer>(chainSize);
        for (int i = 0; i < chainSize; ++i) {
            chain.add(buf.m_130242_());
        }
        return new ElectricChargeTarget(type, entityId, pos, chain);
    }
}

