/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.kismet.particles.ElectricChargeTarget;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class ElectricChargeParticleType
extends ParticleType<Data> {
    public static final Codec<Vector4f> VECTOR4F_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(v -> Float.valueOf(v.x())), (App)Codec.FLOAT.fieldOf("g").forGetter(v -> Float.valueOf(v.y())), (App)Codec.FLOAT.fieldOf("b").forGetter(v -> Float.valueOf(v.z())), (App)Codec.FLOAT.fieldOf("a").forGetter(v -> Float.valueOf(v.w()))).apply((Applicative)instance, Vector4f::new));
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> BuiltInRegistries.f_257034_.m_7981_(data.particleType).toString()), (App)Codec.INT.fieldOf("sender_id").forGetter(data -> data.senderId), (App)Codec.INT.fieldOf("range").forGetter(data -> data.range), (App)Codec.INT.fieldOf("sections").forGetter(data -> data.sections), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.FLOAT.fieldOf("parallel_noise").forGetter(data -> Float.valueOf(data.parallelNoise)), (App)Codec.FLOAT.fieldOf("spread_factor").forGetter(data -> Float.valueOf(data.spreadFactor)), (App)Codec.FLOAT.fieldOf("branch_initiation_factor").forGetter(data -> Float.valueOf(data.branchInitiationFactor)), (App)Codec.FLOAT.fieldOf("branch_continuation_factor").forGetter(data -> Float.valueOf(data.branchContinuationFactor)), (App)Codec.FLOAT.fieldOf("closeness").forGetter(data -> Float.valueOf(data.closeness)), (App)VECTOR4F_CODEC.fieldOf("color").forGetter(data -> data.color), (App)ElectricChargeTarget.CODEC.fieldOf("target").forGetter(data -> data.target)).apply((Applicative)instance, (type, id, range, sections, size, pn, sf, bif, bcf, close, color, target) -> new Data((ParticleType<Data>)((ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(type))), (int)id, (int)range, (int)sections, size.floatValue(), pn.floatValue(), sf.floatValue(), bif.floatValue(), bcf.floatValue(), close.floatValue(), (Vector4f)color, (ElectricChargeTarget)target)));

    public ElectricChargeParticleType(boolean alwaysShow) {
        super(alwaysShow, Data.DESERIALIZER);
    }

    public Codec<Data> m_7652_() {
        return CODEC;
    }

    public static class Data
    implements ParticleOptions {
        public final ParticleType<Data> particleType;
        public final int range;
        public final int sections;
        public final int senderId;
        public final float size;
        public final float parallelNoise;
        public final float spreadFactor;
        public final float branchInitiationFactor;
        public final float branchContinuationFactor;
        public final float closeness;
        public final Vector4f color;
        public final ElectricChargeTarget target;
        public static final ParticleOptions.Deserializer<Data> DESERIALIZER = new ParticleOptions.Deserializer<Data>(){

            public Data fromCommand(ParticleType<Data> type, StringReader reader) throws CommandSyntaxException {
                throw new UnsupportedOperationException("Use JSON/Network for this particle.");
            }

            public Data fromNetwork(ParticleType<Data> type, FriendlyByteBuf buffer) {
                return new Data(type, buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), new Vector4f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), ElectricChargeTarget.read(buffer));
            }
        };

        public Data(ParticleType<Data> type) {
            this(type, -1, 1, 6, 0.13f, 0.3f, 0.125f, 0.25f, 0.66f, 0.15f, new Vector4f(0.05f, 0.5f, 0.9f, 0.75f), new ElectricChargeTarget(TargetType.RANDOM, -1, Vec3.f_82478_, List.of()));
        }

        public Data(ParticleType<Data> type, int senderId, int range, int sections, float size, float pn, float sf, float bif, float bcf, float closeness, Vector4f color, ElectricChargeTarget target) {
            this.senderId = senderId;
            this.particleType = type;
            this.range = range;
            this.sections = sections;
            this.size = size;
            this.parallelNoise = pn;
            this.spreadFactor = sf;
            this.branchInitiationFactor = bif;
            this.branchContinuationFactor = bcf;
            this.closeness = closeness;
            this.color = color;
            this.target = target;
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.senderId);
            buffer.m_130130_(this.range);
            buffer.m_130130_(this.sections);
            buffer.writeFloat(this.size);
            buffer.writeFloat(this.parallelNoise);
            buffer.writeFloat(this.spreadFactor);
            buffer.writeFloat(this.branchInitiationFactor);
            buffer.writeFloat(this.branchContinuationFactor);
            buffer.writeFloat(this.closeness);
            buffer.writeFloat(this.color.x());
            buffer.writeFloat(this.color.y());
            buffer.writeFloat(this.color.z());
            buffer.writeFloat(this.color.w());
            this.target.write(buffer);
        }

        public Data range(int range) {
            return new Data(this.particleType, this.senderId, range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data sections(int sections) {
            return new Data(this.particleType, this.senderId, this.range, sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data size(float size) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data parallelNoise(float value) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, value, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data spreadFactor(float value) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, value, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data branchInitiationFactor(float value) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, value, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data branchContinuationFactor(float value) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, value, this.closeness, this.color, this.target);
        }

        public Data closeness(float value) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, value, this.color, this.target);
        }

        public Data color(Vector4f color) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, color, this.target);
        }

        public Data color(float r, float g, float b, float a) {
            return this.color(new Vector4f(r, g, b, a));
        }

        public Data senderId(int senderId) {
            return new Data(this.particleType, senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, this.target);
        }

        public Data targetRandom() {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, new ElectricChargeTarget(TargetType.RANDOM, -1, Vec3.f_82478_, List.of()));
        }

        public Data targetEntity(int entityId) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, new ElectricChargeTarget(TargetType.ENTITY, entityId, Vec3.f_82478_, List.of()));
        }

        public Data targetPosition(Vec3 pos) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, new ElectricChargeTarget(TargetType.POSITION, -1, pos, List.of()));
        }

        public Data withChainTargets(List<Integer> ids) {
            return new Data(this.particleType, this.senderId, this.range, this.sections, this.size, this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.closeness, this.color, new ElectricChargeTarget(this.target.type(), this.target.entityId(), this.target.position(), ids));
        }

        public String m_5942_() {
            return "lightning_ball_particle";
        }
    }

    public static enum TargetType implements StringRepresentable
    {
        RANDOM,
        ENTITY,
        POSITION,
        CHAIN;

        public static final Codec<TargetType> CODEC;

        public static TargetType byName(String name) {
            return TargetType.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static TargetType fromId(int id) {
            return TargetType.values()[id];
        }

        static {
            CODEC = StringRepresentable.m_216439_(TargetType::values);
        }
    }
}

