/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.scouter.kismet.network.ElectricDamageC2SPacket;
import com.scouter.kismet.network.KNetwork;
import com.scouter.kismet.particles.ElectricBoltData;
import com.scouter.kismet.particles.ElectricChargeParticleType;
import com.scouter.kismet.particles.ElectricChargeTarget;
import com.scouter.kismet.particles.ElectricityRenderer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ElectricChargeParticle
extends Particle {
    private final ElectricityRenderer lightningRender = new ElectricityRenderer();
    private final ElectricChargeParticleType.Data data;
    private Vec3 to;
    private Vec3 lightningOrigin;

    public ElectricChargeParticle(ElectricChargeParticleType.Data data, ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.data = data;
        this.m_107250_(3.0f, 3.0f);
        this.f_107212_ = x;
        this.f_107213_ = y + 0.5;
        this.f_107214_ = z;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        Vec3 from = new Vec3(x, y, z);
        Vec3 lightningTo = this.resolveTarget(data, world, from);
        this.to = lightningTo.m_82546_(from);
        this.lightningOrigin = lightningTo;
        this.f_107225_ = (int)Math.ceil(this.to.m_82553_());
        int sections = data.sections * this.f_107225_;
        ElectricBoltData.BoltRenderInfo boltData = new ElectricBoltData.BoltRenderInfo(data.parallelNoise, data.spreadFactor, data.branchInitiationFactor, data.branchContinuationFactor, data.color, data.closeness);
        ElectricBoltData bolt = new ElectricBoltData(boltData, Vec3.f_82478_, this.to, sections).size(data.size + this.f_107223_.m_188501_() * 0.1f).lifespan(this.f_107225_ + 1).spawn(ElectricBoltData.SpawnFunction.CONSECUTIVE);
        this.lightningRender.update((Object)this, bolt, 1.0f);
    }

    private Vec3 resolveTarget(ElectricChargeParticleType.Data data, ClientLevel level, Vec3 from) {
        ElectricChargeTarget target = data.target;
        return switch (target.type()) {
            case ElectricChargeParticleType.TargetType.ENTITY, ElectricChargeParticleType.TargetType.CHAIN -> {
                Entity entity = level.m_6815_(target.entityId());
                if (entity != null) {
                    double offX = (this.f_107223_.m_188500_() - 0.5) * (double)entity.m_20205_();
                    double offY = this.f_107223_.m_188500_() * (double)entity.m_20206_();
                    double offZ = (this.f_107223_.m_188500_() - 0.5) * (double)entity.m_20205_();
                    yield entity.m_20182_().m_82520_(offX, offY, offZ);
                }
                yield from;
            }
            case ElectricChargeParticleType.TargetType.POSITION -> {
                if (this.canSeeBlock(from, target.position())) {
                    yield target.position();
                }
                yield from;
            }
            default -> this.findRandomLightningTarget(level, from, data.range + this.f_107223_.m_188503_(2));
        };
    }

    private Vec3 findRandomLightningTarget(ClientLevel world, Vec3 origin, int range) {
        for (int i = 0; i < 10; ++i) {
            Vec3 candidate = origin.m_82520_((double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f), (double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f), (double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f));
            if (!this.canSeeBlock(origin, candidate)) continue;
            return candidate;
        }
        return origin;
    }

    private boolean canSeeBlock(Vec3 from, Vec3 to) {
        BlockHitResult result = this.f_107208_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return Vec3.m_82512_((Vec3i)result.m_82425_()).m_82554_(to) < 3.0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        if (this.f_107224_++ >= this.f_107225_) {
            if (this.data.target.type() == ElectricChargeParticleType.TargetType.CHAIN) {
                this.spawnNextChainParticle();
            }
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    private void spawnNextChainParticle() {
        ElectricChargeTarget target = this.data.target;
        if (target.chainTargets().isEmpty()) {
            return;
        }
        Vec3 origin = this.lightningOrigin;
        List<Integer> sorted = target.chainTargets().stream().map(arg_0 -> ((ClientLevel)this.f_107208_).m_6815_(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparingDouble(e -> e.m_20182_().m_82557_(origin))).map(Entity::m_19879_).toList();
        if (sorted.isEmpty()) {
            return;
        }
        int nextId = sorted.get(0);
        List<Integer> remaining = sorted.subList(1, sorted.size());
        Entity nextEntity = this.f_107208_.m_6815_(nextId);
        if (nextEntity != null) {
            ElectricDamageC2SPacket damageC2SPacket = new ElectricDamageC2SPacket(this.data.senderId, nextId, 5.0f, new Vec3(0.0, 0.0, 0.0));
            KNetwork.sendToServer(damageC2SPacket);
            ElectricChargeParticleType.Data newData = this.getData(nextEntity.m_19879_(), remaining);
            Minecraft.m_91087_().f_91073_.m_6493_((ParticleOptions)newData, true, this.lightningOrigin.f_82479_, this.lightningOrigin.f_82480_, this.lightningOrigin.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private  @NotNull ElectricChargeParticleType.Data getData(int nextId, List<Integer> remaining) {
        ElectricChargeTarget newTarget = new ElectricChargeTarget(ElectricChargeParticleType.TargetType.CHAIN, nextId, Vec3.f_82478_, remaining);
        ElectricChargeParticleType.Data newData = new ElectricChargeParticleType.Data(this.data.particleType, this.data.senderId, this.data.range, this.data.sections, this.data.size, this.data.parallelNoise, this.data.spreadFactor, this.data.branchInitiationFactor, this.data.branchContinuationFactor, this.data.closeness, this.data.color, newTarget);
        return newData;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 camPos = camera.m_90583_();
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x - camPos.f_82479_, (double)y - camPos.f_82480_, (double)z - camPos.f_82481_);
        this.lightningRender.render(partialTick, poseStack, (MultiBufferSource)bufferSource);
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ElectricChargeParticleType.Data> {
        public Particle createParticle(ElectricChargeParticleType.Data data, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ElectricChargeParticle(data, level, x, y, z, xd, yd, zd);
        }
    }
}

