/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.network;

import com.scouter.kismet.network.ElectricAttackC2SPacket;
import com.scouter.kismet.network.ElectricChargeSyncS2CPacket;
import com.scouter.kismet.network.ElectricDamageC2SPacket;
import com.scouter.kismet.network.PlaySoundPacket;
import com.scouter.kismet.network.PlayerDataS2CPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class KNetwork {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void registerNetwork() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("kismet", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(ElectricChargeSyncS2CPacket.class, KNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(ElectricChargeSyncS2CPacket::new).encoder(ElectricChargeSyncS2CPacket::toBytes).consumerMainThread(ElectricChargeSyncS2CPacket::handle).add();
        net.messageBuilder(ElectricDamageC2SPacket.class, KNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ElectricDamageC2SPacket::new).encoder(ElectricDamageC2SPacket::toBytes).consumerMainThread(ElectricDamageC2SPacket::handle).add();
        net.messageBuilder(PlayerDataS2CPacket.class, KNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PlayerDataS2CPacket::new).encoder(PlayerDataS2CPacket::toBytes).consumerMainThread(PlayerDataS2CPacket::handle).add();
        net.messageBuilder(ElectricAttackC2SPacket.class, KNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ElectricAttackC2SPacket::new).encoder(ElectricAttackC2SPacket::toBytes).consumerMainThread(ElectricAttackC2SPacket::handle).add();
        net.messageBuilder(PlaySoundPacket.class, KNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PlaySoundPacket::new).encoder(PlaySoundPacket::toBytes).consumerMainThread(PlaySoundPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToClients(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            KNetwork.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayer player) {
        INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        packetId = 0;
    }
}

