/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ElectricDamageC2SPacket {
    private final int targetId;
    private final int senderId;
    private final float damage;
    private final Vec3 knockback;

    public ElectricDamageC2SPacket(int senderId, int targetId, float damage, Vec3 knockback) {
        this.targetId = targetId;
        this.senderId = senderId;
        this.damage = damage;
        this.knockback = knockback;
    }

    public ElectricDamageC2SPacket(FriendlyByteBuf buf) {
        this.targetId = buf.m_130242_();
        this.senderId = buf.m_130242_();
        this.damage = buf.readFloat();
        this.knockback = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.targetId);
        buf.m_130130_(this.senderId);
        buf.writeFloat(this.damage);
        buf.writeDouble(this.knockback.f_82479_);
        buf.writeDouble(this.knockback.f_82480_);
        buf.writeDouble(this.knockback.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity attacker;
            Level level = context.getSender().m_9236_();
            Entity target = level.m_6815_(this.targetId);
            if (target == null) {
                return;
            }
            Entity entity = attacker = this.senderId >= 0 ? level.m_6815_(this.senderId) : null;
            if (target instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)target;
                if (target.m_6084_()) {
                    Entity patt2173$temp;
                    DamageSource source;
                    DamageSource damageSource = source = attacker == null ? level.m_269111_().m_269264_() : attacker.m_269291_().m_268998_(DamageTypes.f_268450_, attacker, target);
                    if (target.m_6469_(source, this.damage) && (patt2173$temp = source.m_7639_()) instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)patt2173$temp;
                        if (target != null) {
                            livingEntity.m_21335_(target);
                        }
                    }
                    target.m_20256_(this.knockback);
                }
            }
            context.setPacketHandled(true);
        });
        return true;
    }
}

