/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.network;

import com.scouter.kismet.data.PlayerData;
import com.scouter.kismet.data.PlayerDataStore;
import com.scouter.kismet.datagen.registries.KDamageTypes;
import com.scouter.kismet.network.ElectricChargeSyncS2CPacket;
import com.scouter.kismet.network.KNetwork;
import com.scouter.kismet.sounds.KSoundEvents;
import com.scouter.kismet.util.CreeperExtension;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElectricAttackC2SPacket {
    public int key;
    public static final Logger LOGGER = LogManager.getLogger();

    public ElectricAttackC2SPacket(int key) {
        this.key = key;
    }

    public ElectricAttackC2SPacket(FriendlyByteBuf buf) {
        this.key = buf.m_130242_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.key);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Level level = player.m_9236_();
            if (player == null || level == null || !(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            PlayerDataStore playerDataStore = PlayerDataStore.get(level);
            PlayerData playerData = playerDataStore.get(player.m_20148_());
            long ATTACK_INTERVAL_TICKS = player.m_7500_() ? 100L : 200L;
            long now = level.m_46467_();
            long last = playerData.lastAttackTick();
            if (playerData.kismetLevel() <= 0 || now - last <= ATTACK_INTERVAL_TICKS) {
                return;
            }
            int COST = 20;
            if (playerData.batteryCharge() < 20) {
                player.m_5661_((Component)Component.m_237115_((String)"kismet.battery.not_enough"), true);
                return;
            }
            playerData = playerData.withLastAttack(now);
            if (!player.m_7500_()) {
                playerData = playerData.withBatteryCharge(playerData.batteryCharge() - 20);
            }
            playerDataStore.putAndSync((Player)player, playerData, serverLevel);
            List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(10.0), EntitySelector.f_20406_.and(arg_0 -> ElectricAttackC2SPacket.lambda$handle$0((Player)player, arg_0))).stream().filter(arg_0 -> ElectricAttackC2SPacket.lambda$handle$1((Player)player, arg_0)).toList();
            this.spawnElectricParticles((Player)player, 10, 5.0f, 50.0f);
            level.m_5594_(null, BlockPos.m_274446_((Position)player.m_20182_()), (SoundEvent)KSoundEvents.ELECTRIC_ATTACK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            for (LivingEntity livingEntity : entityList) {
                DamageSource damageSource = player.m_269291_().m_269079_(KDamageTypes.ELECTRIC_SHOCK);
                if (livingEntity instanceof Creeper) {
                    Creeper creeper = (Creeper)livingEntity;
                    ((CreeperExtension)creeper).kismet$setCharged(true);
                    continue;
                }
                livingEntity.m_6469_(damageSource, 16.0f);
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public void spawnElectricParticles(Player player, int range, float yHeight, float particleMax) {
        Vec3 movement = player.m_20184_();
        double x = player.m_20185_() + movement.f_82479_;
        double y = player.m_20186_() + movement.f_82480_ + (double)(player.m_20206_() / 2.0f);
        double z = player.m_20189_() + movement.f_82481_;
        RandomSource randomSource = player.m_217043_();
        int lightningLength = range;
        float size = 0.08f;
        int i = 0;
        while ((float)i < particleMax) {
            if (!player.m_9236_().f_46443_) {
                ElectricChargeSyncS2CPacket packet = ElectricChargeSyncS2CPacket.builder().pos(x, y, z).range(lightningLength).size(size).color(0.9f + randomSource.m_188501_() / 10.0f, 0.8f + randomSource.m_188501_() / 10.0f, 0.1f + randomSource.m_188501_() / 10.0f, 1.0f).build();
                KNetwork.sendToClients(packet);
            }
            ++i;
        }
    }

    private static /* synthetic */ boolean lambda$handle$1(Player player, LivingEntity livingEntity) {
        return livingEntity.m_20280_((Entity)player) < 25.0;
    }

    private static /* synthetic */ boolean lambda$handle$0(Player player, Entity entity) {
        return entity != player;
    }
}

