/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.events;

import com.scouter.kismet.data.PlayerData;
import com.scouter.kismet.data.PlayerDataStore;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kismet", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void increaseBreakSpeed(PlayerEvent.BreakSpeed event) {
        ServerLevel serverLevel;
        PlayerDataStore dataStore;
        PlayerData data;
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (level instanceof ServerLevel && (data = (dataStore = PlayerDataStore.get((Level)(serverLevel = (ServerLevel)level))).get(player.m_20148_())).batteryCharge() > 0) {
            event.setNewSpeed(event.getOriginalSpeed() * (float)(1 + data.kismetLevel()));
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (entity instanceof Player) {
            ServerLevel serverLevel;
            PlayerDataStore dataStore;
            PlayerData data;
            Player player = (Player)entity;
            if (level instanceof ServerLevel && (data = (dataStore = PlayerDataStore.get((Level)(serverLevel = (ServerLevel)level))).get(player.m_20148_())).kismetLevel() >= 1 && data.batteryCharge() > 0) {
                float damage = event.getAmount();
                if ((player.m_21223_() - event.getAmount() <= 0.0f || damage >= 20.0f) && data.batteryCharge() >= 40) {
                    data = data.withBatteryCharge(data.batteryCharge() - 40);
                    dataStore.putAndSync(player, data, serverLevel);
                    player.m_5661_((Component)Component.m_237115_((String)"kismet.critical_damage.info").m_130940_(ChatFormatting.RED), true);
                    event.setAmount(0.0f);
                } else if (damage >= 5.0f) {
                    event.setAmount(event.getAmount() - (float)data.kismetLevel());
                }
            }
        }
    }

    @SubscribeEvent
    public static void strengthEvent(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7640_();
        Level level = event.getEntity().m_9236_();
        if (entity instanceof Player) {
            ServerLevel serverLevel;
            PlayerDataStore dataStore;
            PlayerData data;
            Player player = (Player)entity;
            if (level instanceof ServerLevel && (data = (dataStore = PlayerDataStore.get((Level)(serverLevel = (ServerLevel)level))).get(player.m_20148_())).kismetLevel() >= 2 && data.batteryCharge() > 0) {
                float damage = event.getAmount();
                float extraDamage = 0.75f * (float)data.kismetLevel();
                event.setAmount(damage + extraDamage);
            }
        }
    }

    @SubscribeEvent
    public static void livingFallEvent(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (entity instanceof Player) {
            ServerLevel serverLevel;
            PlayerDataStore dataStore;
            PlayerData data;
            Player player = (Player)entity;
            if (level instanceof ServerLevel && (data = (dataStore = PlayerDataStore.get((Level)(serverLevel = (ServerLevel)level))).get(player.m_20148_())).kismetLevel() >= 2 && data.batteryCharge() > 0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void synchStuff(PlayerEvent.PlayerLoggedInEvent event) {
        Player entity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (entity instanceof Player) {
            Player player = entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PlayerDataStore dataStore = PlayerDataStore.get((Level)serverLevel);
                PlayerData data = dataStore.get(player.m_20148_());
                if (data.lastBatteryDrainTick() == 0L) {
                    data = data.withLastDrain(level.m_46467_());
                }
                if (data.lastAttackTick() == 0L) {
                    data = data.withLastAttack(level.m_46467_());
                }
                if (data.lastHungerDrainTick() == 0L) {
                    data = data.withLastHungerDrain(level.m_46467_());
                }
                dataStore.putAndSync(player, data, serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void tickBatteryBar(TickEvent.PlayerTickEvent event) {
        long last;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        long DRAIN_INTERVAL_TICKS = 6000L;
        int DRAIN_AMOUNT = 20;
        PlayerDataStore store = PlayerDataStore.get(level);
        PlayerData data = store.get(event.player.m_20148_());
        long now = level.m_46467_();
        if (now - (last = data.lastBatteryDrainTick()) >= 6000L && data.batteryCharge() > 0) {
            int newCharge = Math.max(0, data.batteryCharge() - 20);
            PlayerData updated = data.withBatteryCharge(newCharge).withLastDrain(now);
            store.putAndSync(player, updated, serverLevel);
        }
    }

    @SubscribeEvent
    public static void tickHuner(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        long DRAIN_INTERVAL_TICKS = 100L;
        PlayerDataStore store = PlayerDataStore.get(level);
        PlayerData data = store.get(event.player.m_20148_());
        long now = level.m_46467_();
        long last = data.lastHungerDrainTick();
        if (data.batteryCharge() > 0) {
            player.m_36324_().m_38705_(20);
            return;
        }
        if (now - last >= 100L && data.kismetLevel() > 0) {
            player.m_36399_(20.0f);
            data = data.withLastHungerDrain(now);
            store.putAndSync(player, data, serverLevel);
        }
    }
}

