/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public interface ExtendedNavigator {
    public static final float EPSILON = 1.0E-8f;

    public Mob getMobEN();

    public Path getPathEN();

    default public boolean canPathOnto(BlockPathTypes pathType) {
        return switch (pathType) {
            case BlockPathTypes.WATER, BlockPathTypes.LAVA, BlockPathTypes.OPEN -> false;
            default -> true;
        };
    }

    default public boolean canPathInto(BlockPathTypes pathType) {
        return switch (pathType) {
            case BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DANGER_FIRE, BlockPathTypes.DAMAGE_OTHER -> true;
            default -> false;
        };
    }

    default public boolean isCloseToNextNode(float distance) {
        Mob mob = this.getMobEN();
        Path path = this.getPathEN();
        Vec3 nextNodePos = this.getEntityPosAtNode(path.m_77399_());
        return Math.abs(mob.m_20185_() - nextNodePos.f_82479_) < (double)distance && Math.abs(mob.m_20189_() - nextNodePos.f_82481_) < (double)distance && Math.abs(mob.m_20186_() - nextNodePos.f_82480_) < 1.0;
    }

    default public boolean isAboutToTraverseVertically() {
        Mob mob = this.getMobEN();
        Path path = this.getPathEN();
        int fromNode = path.m_77399_();
        int fromNodeHeight = path.m_77375_((int)fromNode).f_77272_;
        int toNode = Math.min(path.m_77398_(), fromNode + Mth.m_14165_((double)((double)mob.m_20205_() * 0.5)) + 1);
        for (int i = fromNode + 1; i < toNode; ++i) {
            if (path.m_77375_((int)i).f_77272_ == fromNodeHeight) continue;
            return true;
        }
        return false;
    }

    default public boolean attemptShortcut(int targetNode, Vec3 safeSurfacePos) {
        Mob mob = this.getMobEN();
        Path path = this.getPathEN();
        Vec3 position = mob.m_20182_();
        Vec3 minBounds = safeSurfacePos.m_82520_((double)(-mob.m_20205_()) * 0.5, 0.0, (double)(-mob.m_20205_()) * 0.5);
        Vec3 maxBounds = minBounds.m_82520_((double)mob.m_20205_(), (double)mob.m_20206_(), (double)mob.m_20205_());
        for (int nodeIndex = targetNode - 1; nodeIndex > path.m_77399_(); --nodeIndex) {
            Vec3 nodeDelta = this.getEntityPosAtNode(nodeIndex).m_82546_(position);
            if (!this.isCollisionFreeTraversal(nodeDelta, minBounds, maxBounds)) continue;
            path.m_77393_(nodeIndex);
            return true;
        }
        return false;
    }

    default public Vec3 getEntityPosAtNode(int nodeIndex) {
        Mob mob = this.getMobEN();
        Path path = this.getPathEN();
        double lateralOffset = (double)Mth.m_14107_((double)((double)mob.m_20205_() + 1.0)) / 2.0;
        return Vec3.m_82528_((Vec3i)path.m_77396_(nodeIndex)).m_82520_(lateralOffset, 0.0, lateralOffset);
    }

    default public boolean isCollisionFreeTraversal(Vec3 traversalVector, Vec3 minBoundsPos, Vec3 leadingEdgePos) {
        float traversalDistance = (float)traversalVector.m_82553_();
        if (traversalDistance < 1.0E-8f) {
            return true;
        }
        VoxelRayDetails ray = new VoxelRayDetails();
        for (Direction.Axis axis : Direction.Axis.values()) {
            int index = axis.ordinal();
            float axisLength = this.lengthForAxis(traversalVector, axis);
            boolean isPositive = axisLength >= 0.0f;
            float maxPos = this.lengthForAxis(isPositive ? leadingEdgePos : minBoundsPos, axis);
            ray.absStep[index] = isPositive ? 1 : -1;
            ray.minPos[index] = this.lengthForAxis(isPositive ? minBoundsPos : leadingEdgePos, axis);
            ray.leadingEdgeBound[index] = Mth.m_14143_((float)(maxPos - (float)ray.absStep[index] * 1.0E-8f));
            ray.trailingEdgeBound[index] = Mth.m_14143_((float)(ray.minPos[index] + (float)ray.absStep[index] * 1.0E-8f));
            ray.axisLengthNormalised[index] = axisLength / traversalDistance;
            ray.axisSteps[index] = Mth.m_14154_((float)(traversalDistance / axisLength));
            float dist = isPositive ? (float)(ray.leadingEdgeBound[index] + 1) - maxPos : maxPos - (float)ray.leadingEdgeBound[index];
            ray.rayTargetLength[index] = ray.axisSteps[index] < Float.POSITIVE_INFINITY ? ray.axisSteps[index] * dist : Float.POSITIVE_INFINITY;
        }
        return this.collidesWhileTraversing(ray, traversalDistance);
    }

    default public boolean collidesWhileTraversing(VoxelRayDetails ray, float traversalDistance) {
        Mob mob = this.getMobEN();
        Level level = mob.m_9236_();
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            NodeEvaluator nodeEvaluator = mob.m_21573_().m_26575_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            float target = 0.0f;
            do {
                Direction.Axis longestEdge = ray.rayTargetLength[0] < ray.rayTargetLength[1] ? (ray.rayTargetLength[0] < ray.rayTargetLength[2] ? Direction.Axis.X : Direction.Axis.Z) : (ray.rayTargetLength[1] < ray.rayTargetLength[2] ? Direction.Axis.Y : Direction.Axis.Z);
                int index = longestEdge.ordinal();
                float rayDelta = ray.rayTargetLength[index] - target;
                target = ray.rayTargetLength[index];
                int n = index;
                ray.leadingEdgeBound[n] = ray.leadingEdgeBound[n] + ray.absStep[index];
                int n2 = index;
                ray.rayTargetLength[n2] = ray.rayTargetLength[n2] + ray.axisSteps[index];
                for (Direction.Axis axis : Direction.Axis.values()) {
                    int index2;
                    int n3 = index2 = axis.ordinal();
                    ray.minPos[n3] = ray.minPos[n3] + rayDelta * ray.axisLengthNormalised[index2];
                    ray.trailingEdgeBound[index2] = Mth.m_14143_((float)(ray.minPos[index2] + (float)ray.absStep[index2] * 1.0E-8f));
                }
                int xStep = ray.absStep[0];
                int yStep = ray.absStep[1];
                int zStep = ray.absStep[2];
                int xBound = longestEdge == Direction.Axis.X ? ray.leadingEdgeBound[0] : ray.trailingEdgeBound[0];
                int yBound = longestEdge == Direction.Axis.Y ? ray.leadingEdgeBound[1] : ray.trailingEdgeBound[1];
                int zBound = longestEdge == Direction.Axis.Z ? ray.leadingEdgeBound[2] : ray.trailingEdgeBound[2];
                int xStepBound = ray.leadingEdgeBound[0] + xStep;
                int yStepBound = ray.leadingEdgeBound[1] + yStep;
                int zStepBound = ray.leadingEdgeBound[2] + zStep;
                for (int x = xBound; x != xStepBound; x += xStep) {
                    for (int z = zBound; z != zStepBound; z += zStep) {
                        int y;
                        for (y = yBound; y != yStepBound; y += yStep) {
                            if (sectionAccess.m_156110_((BlockPos)pos.m_122178_(x, y, z)).m_60647_((BlockGetter)level, (BlockPos)pos, PathComputationType.LAND)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathOnto(nodeEvaluator.m_8086_((BlockGetter)level, x, yBound - 1, z))) {
                            y = 0;
                            return y != 0;
                        }
                        BlockPathTypes insidePathType = nodeEvaluator.m_8086_((BlockGetter)level, x, yBound, z);
                        float pathMalus = mob.m_21439_(insidePathType);
                        if (pathMalus < 0.0f || pathMalus >= 8.0f) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathInto(insidePathType)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            } while (target <= traversalDistance);
        }
        return true;
    }

    default public float lengthForAxis(Vec3 vector, Direction.Axis axis) {
        return (float)axis.m_6150_(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public record VoxelRayDetails(float[] minPos, int[] leadingEdgeBound, int[] trailingEdgeBound, int[] absStep, float[] axisSteps, float[] rayTargetLength, float[] axisLengthNormalised) {
        public VoxelRayDetails() {
            this(new float[3], new int[3], new int[3], new int[3], new float[3], new float[3], new float[3]);
        }
    }
}

