/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity.ai;

import com.scouter.kismet.datagen.registries.KDamageTypes;
import com.scouter.kismet.entity.KismetEntity;
import com.scouter.kismet.entity.MegaByteEntity;
import com.scouter.kismet.sounds.KSoundEvents;
import com.scouter.kismet.util.CreeperExtension;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;

public class MegaByteElectricAttackGoal
extends Goal {
    private int animTimer;
    private MegaByteEntity entity;
    private int cooldown;

    public MegaByteElectricAttackGoal(MegaByteEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entity;
    }

    public boolean m_8036_() {
        boolean coolDown = this.cooldown-- <= 0;
        return !this.entity.m_6162_() && this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() && coolDown && !this.entity.isMeleeAttack() && !this.entity.isHeavyAttack();
    }

    public boolean m_8045_() {
        return !this.entity.m_6162_() && this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() && this.cooldown <= 0;
    }

    public void m_8056_() {
        this.animTimer = 0;
        this.entity.setElectricAttack(false);
    }

    public void m_8041_() {
        this.entity.setElectricAttack(false);
        super.m_8041_();
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            this.entity.m_21391_((Entity)this.entity.m_5448_(), 30.0f, 30.0f);
            this.entity.m_21563_().m_24960_((Entity)this.entity.m_5448_(), 30.0f, 30.0f);
            double distance = this.entity.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.entity.m_21573_().m_5624_((Entity)target, 2.0);
            if (distance <= 25.0) {
                this.tickAttack();
            }
        }
    }

    protected void tickAttack() {
        ++this.animTimer;
        this.entity.setElectricAttack(true);
        if (this.animTimer == 12) {
            List<LivingEntity> entityList = this.entity.m_9236_().m_6443_(LivingEntity.class, this.entity.m_20191_().m_82400_(10.0), EntitySelector.f_20406_.and(entity -> !(entity instanceof KismetEntity))).stream().filter(livingEntity -> livingEntity.m_20280_((Entity)this.entity) < 25.0).toList();
            this.entity.m_5496_((SoundEvent)KSoundEvents.ELECTRIC_ATTACK.get(), 1.0f, 1.0f);
            this.entity.spawnElectricParticles(15, 5.0f, 75.0f);
            for (LivingEntity livingEntity2 : entityList) {
                DamageSource damageSource = this.entity.m_269291_().m_269079_(KDamageTypes.ELECTRIC_SHOCK);
                if (livingEntity2 instanceof Creeper) {
                    Creeper creeper = (Creeper)livingEntity2;
                    ((CreeperExtension)creeper).kismet$setCharged(true);
                    continue;
                }
                livingEntity2.m_6469_(damageSource, 32.0f);
            }
        }
        if (this.animTimer > 20) {
            this.animTimer = 0;
            this.entity.setElectricAttack(false);
            this.cooldown = 100;
        }
    }

    protected double getAttackReach(LivingEntity target) {
        return this.entity.m_20205_() * 1.1f * this.entity.m_20205_() * 1.1f + target.m_20205_();
    }
}

