/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity.ai;

import com.scouter.kismet.entity.KiloByteEntity;
import com.scouter.kismet.sounds.KSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class KiloByteLungeAttackGoal
extends Goal {
    private final KiloByteEntity kiloByteEntity;
    private int timer;
    private Vec3 chargeDirection;

    public KiloByteLungeAttackGoal(KiloByteEntity kiloByteEntity) {
        this.kiloByteEntity = kiloByteEntity;
        this.chargeDirection = Vec3.f_82478_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return !this.kiloByteEntity.m_20160_() && !this.kiloByteEntity.m_6162_() && this.kiloByteEntity.m_5448_() != null && this.kiloByteEntity.m_5448_().m_6084_() && this.kiloByteEntity.getChargeCooldown() <= 0 && !this.kiloByteEntity.m_20072_();
    }

    public void m_8056_() {
        LivingEntity target = this.kiloByteEntity.m_5448_();
        if (target == null) {
            return;
        }
        this.timer = 0;
        this.kiloByteEntity.setCharging(true);
        this.kiloByteEntity.m_6858_(true);
    }

    public void m_8041_() {
        this.timer = 0;
        this.kiloByteEntity.setCharging(false);
        this.kiloByteEntity.m_6858_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.kiloByteEntity.m_5448_();
        BlockPos pos = this.kiloByteEntity.m_20183_();
        int speedFactor = this.kiloByteEntity.m_21023_(MobEffects.f_19596_) ? this.kiloByteEntity.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
        int slownessFactor = this.kiloByteEntity.m_21023_(MobEffects.f_19597_) ? this.kiloByteEntity.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
        float effectSpeed = 0.1f * (float)(speedFactor - slownessFactor);
        if (target != null) {
            ++this.timer;
            this.kiloByteEntity.m_21573_().m_26573_();
            if (this.timer < 17) {
                this.kiloByteEntity.m_21391_((Entity)target, 360.0f, 30.0f);
                this.kiloByteEntity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.timer == 17) {
                Vec3 targetPos = target.m_20182_();
                this.chargeDirection = new Vec3((double)pos.m_123341_() - targetPos.m_7096_(), 0.0, (double)pos.m_123343_() - targetPos.m_7094_()).m_82541_();
            }
            if (this.timer > 20) {
                if (this.timer % 10 == 0) {
                    this.kiloByteEntity.m_5496_((SoundEvent)KSoundEvents.KILOBYTE_CHARGE.get(), 1.0f, 1.0f);
                }
                this.kiloByteEntity.m_20334_(this.chargeDirection.f_82479_ * (-0.7 - (double)effectSpeed), this.kiloByteEntity.m_20184_().f_82480_, this.chargeDirection.f_82481_ * (-0.7 - (double)effectSpeed));
                this.tryToHurt();
            }
            if (this.timer >= 75 || this.kiloByteEntity.f_19862_ || this.kiloByteEntity.m_20069_()) {
                this.finishCharging(this.kiloByteEntity);
            }
        }
    }

    private void tryToHurt() {
        LivingEntity entity;
        List nearbyEntities = this.kiloByteEntity.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.kiloByteEntity, this.kiloByteEntity.m_20191_());
        if (!nearbyEntities.isEmpty() && !((entity = (LivingEntity)nearbyEntities.get(0)) instanceof KiloByteEntity)) {
            int speedFactor = this.kiloByteEntity.m_21023_(MobEffects.f_19596_) ? this.kiloByteEntity.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
            int slownessFactor = this.kiloByteEntity.m_21023_(MobEffects.f_19597_) ? this.kiloByteEntity.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
            float effectSpeed = 0.15f * (float)(speedFactor - slownessFactor);
            float speedForce = Mth.m_14036_((float)(this.kiloByteEntity.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + effectSpeed;
            float knockbackForce = entity.m_21275_(this.kiloByteEntity.m_9236_().m_269111_().m_269333_((LivingEntity)this.kiloByteEntity)) ? 1.75f : 2.25f;
            entity.m_6469_(entity.m_269291_().m_269333_((LivingEntity)this.kiloByteEntity), (float)this.kiloByteEntity.m_21133_(Attributes.f_22281_));
            entity.m_147240_((double)(knockbackForce * speedForce * 2.5f), this.chargeDirection.m_7096_(), this.chargeDirection.m_7094_());
            if (entity.m_21275_(this.kiloByteEntity.m_269291_().m_269333_((LivingEntity)this.kiloByteEntity)) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36384_(true);
            }
            this.kiloByteEntity.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    private void finishCharging(KiloByteEntity kiloByteEntity) {
        this.timer = 0;
        kiloByteEntity.chargeCooldown();
    }
}

