/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity;

import com.scouter.kismet.entity.KismetEntity;
import com.scouter.kismet.entity.ai.MegaByteElectricAttackGoal;
import com.scouter.kismet.entity.ai.MegaByteHeavyAttackGoal;
import com.scouter.kismet.entity.ai.MegaByteMeleeAttackGoal;
import com.scouter.kismet.network.ElectricChargeSyncS2CPacket;
import com.scouter.kismet.network.KNetwork;
import com.scouter.kismet.sounds.KSoundEvents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MegaByteEntity
extends KismetEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation BLINKING_BLEND = RawAnimation.begin().thenLoop("animation.gigabyte.blinking_blend");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.gigabyte.idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.gigabyte.walk");
    public static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.gigabyte.run");
    public static final RawAnimation SLAM = RawAnimation.begin().thenPlay("animation.gigabyte.slam");
    public static final RawAnimation STOMP_FRONT = RawAnimation.begin().thenPlay("animation.gigabyte.stomp_front");
    public static final RawAnimation STOMP_BACK = RawAnimation.begin().thenPlay("animation.gigabyte.stomp_back");
    public static final RawAnimation ELECTRIC_BLAST = RawAnimation.begin().thenPlay("animation.gigabyte.electric_blast");
    private static final EntityDataAccessor<Boolean> ELECTRIC_ATTACK = SynchedEntityData.m_135353_(MegaByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELEE_ATTACK = SynchedEntityData.m_135353_(MegaByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAVY_ATTACK = SynchedEntityData.m_135353_(MegaByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected MegaByteEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.1f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, (double)0.08f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 35.0);
    }

    protected float m_6118_() {
        return 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MegaByteElectricAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MegaByteHeavyAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MegaByteMeleeAttackGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, e -> !(e instanceof KismetEntity)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELECTRIC_ATTACK, (Object)false);
        this.f_19804_.m_135372_(MELEE_ATTACK, (Object)false);
        this.f_19804_.m_135372_(HEAVY_ATTACK, (Object)false);
    }

    @Override
    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)KSoundEvents.MEGABYTE_IDLE.get();
    }

    public boolean m_271807_() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.isHeavyAttack() || this.isElectricAttack()) {
            pTravelVector = Vec3.f_82478_;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount);
    }

    public boolean isElectricAttack() {
        return (Boolean)this.f_19804_.m_135370_(ELECTRIC_ATTACK);
    }

    public void setElectricAttack(boolean attack) {
        this.f_19804_.m_135381_(ELECTRIC_ATTACK, (Object)attack);
    }

    public boolean isMeleeAttack() {
        return (Boolean)this.f_19804_.m_135370_(MELEE_ATTACK);
    }

    public void setMeleeAttack(boolean attack) {
        this.f_19804_.m_135381_(MELEE_ATTACK, (Object)attack);
    }

    public boolean isHeavyAttack() {
        return (Boolean)this.f_19804_.m_135370_(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.f_19804_.m_135381_(HEAVY_ATTACK, (Object)attack);
    }

    public void spawnElectricParticles(int range, float yHeight, float particleMax) {
        Vec3 movement = this.m_20184_();
        double x = this.m_20185_() + movement.f_82479_;
        double y = this.m_20186_() + movement.f_82480_ + (double)(this.m_20206_() / 2.0f);
        double z = this.m_20189_() + movement.f_82481_;
        RandomSource randomSource = this.m_217043_();
        int lightningLength = range;
        float size = 0.08f;
        int i = 0;
        while ((float)i < particleMax) {
            if (!this.m_9236_().f_46443_) {
                ElectricChargeSyncS2CPacket packet = ElectricChargeSyncS2CPacket.builder().pos(x, y, z).range(lightningLength).size(size).color(0.9f + randomSource.m_188501_() / 10.0f, 0.8f + randomSource.m_188501_() / 10.0f, 0.1f + randomSource.m_188501_() / 10.0f, 1.0f).build();
                KNetwork.sendToClients(packet);
            }
            ++i;
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate);
        controllers.add(new AnimationController[]{controller});
        AnimationController controller2 = new AnimationController((GeoAnimatable)this, "controller2", 5, this::predicate2);
        controllers.add(new AnimationController[]{controller2});
        AnimationController controller3 = new AnimationController((GeoAnimatable)this, "controller3", 5, this::predicate3);
        controllers.add(new AnimationController[]{controller3});
    }

    protected <E extends MegaByteEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.setAndContinue(WALK);
            return PlayState.CONTINUE;
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends MegaByteEntity> PlayState predicate2(AnimationState<E> event) {
        return event.setAndContinue(BLINKING_BLEND);
    }

    protected <E extends MegaByteEntity> PlayState predicate3(AnimationState<E> event) {
        if (this.isMeleeAttack()) {
            event.setAndContinue(STOMP_FRONT);
            return PlayState.CONTINUE;
        }
        if (this.isHeavyAttack()) {
            event.setAndContinue(SLAM);
            return PlayState.CONTINUE;
        }
        if (this.isElectricAttack()) {
            event.setAndContinue(ELECTRIC_BLAST);
            return PlayState.CONTINUE;
        }
        event.resetCurrentAnimation();
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

