/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity;

import com.scouter.kismet.entity.navigation.SmoothGroundPathNavigation;
import com.scouter.kismet.sounds.KSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public abstract class KismetEntity
extends PathfinderMob
implements GeoAnimatable,
GeoEntity {
    protected KismetEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.setupAnimationCooldowns();
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new SmoothGroundPathNavigation((Mob)this, pLevel);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity instanceof KismetEntity;
    }

    public void setupAnimationCooldowns() {
    }

    public void setupAnimationStates() {
    }

    public boolean isInPoseTransition() {
        return false;
    }

    public boolean refuseToMove() {
        return this.isInPoseTransition();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)KSoundEvents.KISMET_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)KSoundEvents.KISMET_DEATH.get();
    }

    public boolean canSwimInFluidType(FluidType type) {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public static boolean checkKismetESpawnRules(EntityType<? extends KismetEntity> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && KismetEntity.checkKismetSpawnRules(pType, (LevelAccessor)pLevel, pSpawnType, pPos, pRandom);
    }

    public static boolean checkKismetEnemySpawnRules(EntityType<? extends KismetEntity> pType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && KismetEntity.checkKismetSpawnRules(pType, pLevel, pSpawnType, pPos, pRandom);
    }

    public static boolean checkKismetSpawnRules(EntityType<? extends KismetEntity> pType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos = pPos.m_7495_();
        return pSpawnType == MobSpawnType.SPAWNER || pLevel.m_8055_(blockpos).m_60643_((BlockGetter)pLevel, blockpos, pType);
    }
}

