/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity;

import com.scouter.kismet.entity.KismetEntity;
import com.scouter.kismet.entity.ai.KiloByteAttackGoal;
import com.scouter.kismet.entity.ai.KiloByteLungeAttackGoal;
import com.scouter.kismet.sounds.KSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KiloByteEntity
extends KismetEntity {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.kilobyte.idle");
    public static final RawAnimation NECK_TWIST_1 = RawAnimation.begin().thenLoop("animation.kilobyte.necktwist_blend1");
    public static final RawAnimation NECK_TWIST_2 = RawAnimation.begin().thenLoop("animation.kilobyte.necktwist_blend2");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.kilobyte.walk");
    public static final RawAnimation CHARGE = RawAnimation.begin().thenLoop("animation.kilobyte.charge");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.kilobyte.attack");
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(KiloByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CHARGE_COOLDOWN = SynchedEntityData.m_135353_(KiloByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STUNNED_TICK = SynchedEntityData.m_135353_(KiloByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_COOLDOWN = SynchedEntityData.m_135353_(KiloByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(KiloByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected KiloByteEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new KiloByteLungeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new KiloByteAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, false));
    }

    protected void m_6731_(@NotNull LivingEntity defender) {
        this.setStunnedTick();
        this.chargeCooldown();
        this.m_21573_().m_26573_();
        this.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)39);
        defender.m_7334_((Entity)this);
        defender.f_19864_ = true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate);
        controllers.add(new AnimationController[]{controller});
        AnimationController controller2 = new AnimationController((GeoAnimatable)this, "controller2", 5, this::predicate2);
        controllers.add(new AnimationController[]{controller2});
    }

    protected <E extends KiloByteEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isStunned()) {
            return event.setAndContinue(NECK_TWIST_1);
        }
        if (this.isCharging()) {
            return event.setAndContinue(CHARGE);
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends KiloByteEntity> PlayState predicate2(AnimationState<E> event) {
        if (this.isAttacking()) {
            return event.setAndContinue(ATTACK);
        }
        event.resetCurrentAnimation();
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(CHARGE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(STUNNED_TICK, (Object)0);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_COOLDOWN, (Object)0);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.isStunned()) {
            super.m_7023_(Vec3.f_82478_);
        }
        super.m_7023_(pTravelVector);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isStunned()) {
            this.setStunnedTick(this.getStunnedTick() - 1);
            this.stunEffect();
        }
        if (this.getChargeCooldown() > 0) {
            this.setChargeCooldown(this.getChargeCooldown() - 1);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)KSoundEvents.KILOBYTE_IDLE.get();
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double e = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double f = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123797_, true, this.m_20185_(), this.m_20188_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Charging", this.isCharging());
        compoundTag.m_128405_("ChargeCooldown", this.getChargeCooldown());
        compoundTag.m_128405_("StunnedTick", this.getStunnedTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCharging(compoundTag.m_128471_("Charging"));
        this.setChargeCooldown(compoundTag.m_128451_("ChargeCooldown"));
        this.setStunnedTick(compoundTag.m_128451_("StunnedTick"));
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isStunned();
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean charging) {
        this.f_19804_.m_135381_(ATTACKING, (Object)charging);
    }

    public int getAttackCooldown() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int cooldown) {
        this.f_19804_.m_135381_(ATTACK_COOLDOWN, (Object)cooldown);
    }

    public int getChargeCooldown() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN);
    }

    public void setChargeCooldown(int cooldown) {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN, (Object)cooldown);
    }

    public void chargeCooldown() {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN, (Object)(100 + this.m_217043_().m_188503_(100)));
    }

    public boolean isStunned() {
        return this.getStunnedTick() > 0;
    }

    public int getStunnedTick() {
        return (Integer)this.f_19804_.m_135370_(STUNNED_TICK);
    }

    public void setStunnedTick(int stunnedTick) {
        this.f_19804_.m_135381_(STUNNED_TICK, (Object)stunnedTick);
    }

    public void setStunnedTick() {
        this.f_19804_.m_135381_(STUNNED_TICK, (Object)100);
    }
}

