/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity;

import com.scouter.kismet.entity.KismetEntity;
import com.scouter.kismet.entity.navigation.FlyingMoveController;
import com.scouter.kismet.entity.navigation.FlyingPathNavigationNoSpin;
import com.scouter.kismet.entity.navigation.SmoothGroundPathNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class FlyingKismetEntity
extends KismetEntity
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(FlyingKismetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected float flyProgress;
    protected float prevFlyProgress;
    protected float groundProgress = 5.0f;
    protected float prevGroundProgress = 5.0f;
    public int timeFlying = 0;
    protected float flightPitch = 0.0f;
    protected float prevFlightPitch = 0.0f;
    protected float flightRoll = 0.0f;
    protected float prevFlightRoll = 0.0f;
    public boolean isLandNavigator;
    public boolean landingFlag;
    public boolean useLowerFluidJumpThreshold = false;
    public float currentRoll = 0.0f;
    public float prevTilt;
    public float tilt;

    protected FlyingKismetEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = new FlyingLookControl(this);
    }

    protected BodyRotationControl m_7560_() {
        return new FlyingBodyRotationControl(this);
    }

    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new SmoothGroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new FlyingMoveController(this);
            this.f_21344_ = new FlyingPathNavigationNoSpin((Mob)this, this.m_9236_(), 1.0f);
            this.isLandNavigator = false;
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public double m_20204_() {
        if (this.useLowerFluidJumpThreshold) {
            return super.m_20204_();
        }
        return 0.6 * (double)this.m_20206_();
    }

    private void setUseLowerFluidJumpThreshold(boolean jumpThreshold) {
        this.useLowerFluidJumpThreshold = jumpThreshold;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_() && this.f_19862_) {
            this.setUseLowerFluidJumpThreshold(true);
        }
        if (this.m_29443_()) {
            this.m_20124_(Pose.FALL_FLYING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20072_() && !this.m_29443_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.1, 1.0));
        }
        super.m_7023_(travelVector);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.prevGroundProgress = this.groundProgress;
        this.prevFlightPitch = this.flightPitch;
        this.prevFlightRoll = this.flightRoll;
        this.tickFlight();
        this.tickRotation((float)this.m_20184_().f_82480_ * 2.0f * -57.295776f);
    }

    public void tickFlight() {
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            this.m_20242_(true);
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
            if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        this.prevTilt = this.tilt;
        if (this.m_29443_() && !this.m_20096_()) {
            float v = Mth.m_14118_((float)this.m_146908_(), (float)this.f_19859_);
            if (Math.abs(v) > 1.0f) {
                if (Math.abs(this.tilt) < 25.0f) {
                    this.tilt -= Math.signum(v);
                }
            } else if (Math.abs(this.tilt) > 0.0f) {
                float tiltSign = Math.signum(this.tilt);
                this.tilt -= tiltSign * 0.85f;
                if (this.tilt * tiltSign < 0.0f) {
                    this.tilt = 0.0f;
                }
            }
        } else {
            this.tilt = 0.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
                }
                if ((this.f_19862_ || this.m_20072_()) && !this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
            }
            if (this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        }
        float prevRoll = this.currentRoll;
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (this.m_146908_() - this.f_19859_) * 0.1f));
        targetRoll = -targetRoll;
        this.currentRoll = prevRoll + (targetRoll - prevRoll) * 0.05f;
    }

    public void tickRotation(float yMov) {
        this.flightPitch = yMov;
        float threshold = 1.0f;
        boolean flag = false;
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() > threshold) {
            this.flightRoll += 10.0f;
            flag = true;
        }
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() < -threshold) {
            this.flightRoll -= 10.0f;
            flag = true;
        }
        if (!flag) {
            if (this.flightRoll > 0.0f) {
                this.flightRoll = Math.max(this.flightRoll - 5.0f, 0.0f);
            }
            if (this.flightRoll < 0.0f) {
                this.flightRoll = Math.min(this.flightRoll + 5.0f, 0.0f);
            }
        }
        this.flightRoll = Mth.m_14036_((float)this.flightRoll, (float)-60.0f, (float)60.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Flying", this.m_29443_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setFlying(pCompound.m_128471_("Flying"));
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public float getFlightPitch(float partialTick) {
        return this.prevFlightPitch + (this.flightPitch - this.prevFlightPitch) * partialTick;
    }

    public float getFlightRoll(float partialTick) {
        return this.prevFlightRoll + (this.flightRoll - this.prevFlightRoll) * partialTick;
    }

    public float getFlyProgress(float partialTick) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTick) * 0.2f;
    }

    public static class FlyingLookControl
    extends LookControl {
        protected final KismetEntity mob;

        public FlyingLookControl(KismetEntity mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8128_() {
            if (!this.mob.refuseToMove()) {
                super.m_8128_();
            }
        }
    }

    public static class FlyingBodyRotationControl
    extends BodyRotationControl {
        protected final KismetEntity mob;

        public FlyingBodyRotationControl(KismetEntity mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8121_() {
            if (!this.mob.refuseToMove()) {
                super.m_8121_();
            }
        }
    }
}

