/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.entity;

import com.scouter.kismet.datagen.registries.KDamageTypes;
import com.scouter.kismet.entity.FlyingKismetEntity;
import com.scouter.kismet.entity.KiloByteEntity;
import com.scouter.kismet.entity.KismetEntity;
import com.scouter.kismet.entity.MegaByteEntity;
import com.scouter.kismet.entity.NearestAttackableTargetGoalImproved3D;
import com.scouter.kismet.entity.ai.FlyTowardsTarget;
import com.scouter.kismet.entity.ai.MoveTowardsTargetGoalExtended;
import com.scouter.kismet.entity.ai.RandomFlightGoal;
import com.scouter.kismet.network.ElectricChargeSyncS2CPacket;
import com.scouter.kismet.network.KNetwork;
import com.scouter.kismet.sounds.KSoundEvents;
import com.scouter.kismet.util.CreeperExtension;
import com.scouter.kismet.util.KTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ByteEntity
extends FlyingKismetEntity {
    public static final RawAnimation FLYING = RawAnimation.begin().thenLoop("animation.byte.fly");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.byte.idle");
    public static final RawAnimation ELECTRIC_ATTACK_FLASH_ANIM = RawAnimation.begin().thenPlay("animation.byte.flashing_blend");
    public static final RawAnimation ELECTRIC_ATTACK_EXPLODE_ANIM = RawAnimation.begin().thenPlay("animation.byte.explode_blend");
    private static final Logger log = LoggerFactory.getLogger(ByteEntity.class);
    private static final EntityDataAccessor<Boolean> ELECTRIC_ATTACK = SynchedEntityData.m_135353_(ByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWNED_PARTICLES = SynchedEntityData.m_135353_(ByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_ATTACK = SynchedEntityData.m_135353_(ByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RECHARGE_TIME = SynchedEntityData.m_135353_(ByteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean spawnedParticles;
    private int rechargeTime;

    protected ByteEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.switchNavigator(false);
    }

    @Override
    public void m_8119_() {
        boolean hasEnoughCharge;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<LivingEntity> entityList = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(10.0), EntitySelector.f_20406_.and(entity -> !(entity instanceof KismetEntity))).stream().filter(livingEntity -> livingEntity.m_20280_((Entity)this) < 25.0).toList();
        if (entityList.isEmpty() && this.getRechargeTime() <= 0) {
            this.setElectricAttack(false);
            this.setSpawnedParticles(false);
            this.setCanAttack(false);
            return;
        }
        boolean isCharging = this.getRechargeTime() < 72 && !this.isSpawnedParticles();
        boolean isAttacking = this.isSpawnedParticles() && this.getRechargeTime() < 80;
        boolean bl = hasEnoughCharge = this.getRechargeTime() > 10;
        if (isCharging) {
            this.incrementRechargeTime();
            this.setElectricAttack(true);
            return;
        }
        if (!this.isSpawnedParticles()) {
            this.spawnElectricParticles(10, 5.0f, 50.0f);
            this.m_5496_((SoundEvent)KSoundEvents.ELECTRIC_ATTACK.get(), 1.0f, 1.0f);
            this.setSpawnedParticles(true);
            for (LivingEntity livingEntity2 : entityList) {
                DamageSource damageSource = this.m_269291_().m_269079_(KDamageTypes.ELECTRIC_SHOCK);
                if (livingEntity2 instanceof Creeper) {
                    Creeper creeper = (Creeper)livingEntity2;
                    ((CreeperExtension)creeper).kismet$setCharged(true);
                    continue;
                }
                livingEntity2.m_6469_(damageSource, 16.0f);
            }
            this.setFlying(true);
            this.m_6710_(null);
            this.f_21345_.m_148105_().forEach(g -> {
                Goal patt5768$temp = g.m_26015_();
                if (patt5768$temp instanceof RandomFlightGoal) {
                    RandomFlightGoal randomFlightGoal = (RandomFlightGoal)patt5768$temp;
                    randomFlightGoal.m_8036_();
                }
            });
            this.setElectricAttack(false);
        }
        this.m_6710_(null);
        this.incrementRechargeTime();
        if (this.getRechargeTime() >= 500) {
            this.resetRechargeTime();
            this.setSpawnedParticles(false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && source.m_7639_() != null) {
            double range = 8.0;
            List list = this.m_9236_().m_45976_(ByteEntity.class, this.m_20191_().m_82377_(range, range / 2.0, range));
            for (ByteEntity byteEntity : list) {
                byteEntity.setFlying(true);
                Entity entity = source.m_7640_();
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                byteEntity.m_6703_(livingEntity);
            }
        }
        return hurt;
    }

    public void spawnElectricParticles(int range, float yHeight, float particleMax) {
        Vec3 movement = this.m_20184_();
        double x = this.m_20185_() + movement.f_82479_;
        double y = this.m_20186_() + movement.f_82480_;
        double z = this.m_20189_() + movement.f_82481_;
        RandomSource randomSource = this.m_217043_();
        int lightningLength = range;
        float size = 0.08f;
        int i = 0;
        while ((float)i < particleMax) {
            if (!this.m_9236_().f_46443_) {
                ElectricChargeSyncS2CPacket packet = ElectricChargeSyncS2CPacket.builder().pos(x, y, z).range(lightningLength).size(size).color(0.9f + randomSource.m_188501_() / 10.0f, 0.8f + randomSource.m_188501_() / 10.0f, 0.1f + randomSource.m_188501_() / 10.0f, 1.0f).build();
                KNetwork.sendToClients(packet);
            }
            ++i;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELECTRIC_ATTACK, (Object)false);
        this.f_19804_.m_135372_(SPAWNED_PARTICLES, (Object)false);
        this.f_19804_.m_135372_(CAN_ATTACK, (Object)false);
        this.f_19804_.m_135372_(RECHARGE_TIME, (Object)0);
    }

    @Override
    public boolean isInPoseTransition() {
        return this.isElectricAttack();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFlightGoal(this, 0.75f, 16, 4, 0, 1200));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoalExtended(this, 1.0, 15.0f));
        this.f_21345_.m_25352_(2, (Goal)new FlyTowardsTarget(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{MegaByteEntity.class, KiloByteEntity.class, ByteEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoalImproved3D((Mob)this, KTags.BYTE_TARGETS, false));
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos above = this.m_20183_().m_7494_();
        if (world.m_46859_(above)) {
            this.setFlying(true);
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL || reason == MobSpawnType.SPAWN_EGG) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 10.0);
    }

    @Override
    public void setupAnimationStates() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate);
        controllers.add(new AnimationController[]{controller});
    }

    protected <E extends ByteEntity> PlayState predicate(AnimationState<E> event) {
        if (this.getRechargeTime() < 60 && this.getRechargeTime() > 0) {
            event.setAndContinue(ELECTRIC_ATTACK_FLASH_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.getRechargeTime() > 60 && this.getRechargeTime() < 90 && this.isElectricAttack()) {
            event.setAndContinue(ELECTRIC_ATTACK_EXPLODE_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.m_29443_() && this.m_20184_().m_165925_() > 1.0E-6) {
            event.setAndContinue(FLYING);
            return PlayState.CONTINUE;
        }
        return event.setAndContinue(IDLE);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)KSoundEvents.BYTE_IDLE.get();
    }

    public boolean isElectricAttack() {
        return (Boolean)this.f_19804_.m_135370_(ELECTRIC_ATTACK);
    }

    public void setElectricAttack(boolean attack) {
        this.f_19804_.m_135381_(ELECTRIC_ATTACK, (Object)attack);
    }

    public boolean isSpawnedParticles() {
        return (Boolean)this.f_19804_.m_135370_(SPAWNED_PARTICLES);
    }

    public void setSpawnedParticles(boolean particles) {
        this.f_19804_.m_135381_(SPAWNED_PARTICLES, (Object)particles);
    }

    public void setCanAttack(boolean attack) {
        this.f_19804_.m_135381_(CAN_ATTACK, (Object)attack);
    }

    public void incrementRechargeTime() {
        this.incrementRechargeTime(1);
    }

    public void resetRechargeTime() {
        this.setRechargeTime(0);
    }

    public void incrementRechargeTime(int increment) {
        this.setRechargeTime(this.getRechargeTime() + increment);
    }

    public int getRechargeTime() {
        return (Integer)this.f_19804_.m_135370_(RECHARGE_TIME);
    }

    public void setRechargeTime(int time) {
        this.f_19804_.m_135381_(RECHARGE_TIME, (Object)time);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

