/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.datagen.registries;

import com.scouter.kismet.Kismet;
import com.scouter.kismet.datagen.registries.KPools;
import com.scouter.kismet.entity.KEntities;
import com.scouter.kismet.structures.KismetStructure;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.Tags;

public class KStructuresData {
    public static final ResourceKey<Structure> KISMET_STRUCTURE = KStructuresData.createKey("kismet_structure");

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)Kismet.prefix(name));
    }

    public static void bootstrap(BootstapContext<Structure> context) {
        Map<MobCategory, StructureSpawnOverride> mobSpawnsBox = Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)KEntities.KILOBYTE.get(), 3, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)KEntities.BYTE.get(), 4, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)KEntities.MEGABYTE.get(), 1, 1, 2)})));
        Map<MobCategory, StructureSpawnOverride> mobSpawnsPiece = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146332_())));
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter placements = context.m_255420_(Registries.f_256988_);
        HolderGetter configurations = context.m_255420_(Registries.f_256911_);
        HolderGetter processors = context.m_255420_(Registries.f_257011_);
        HolderGetter structureTemplatePoolHolder = context.m_255420_(Registries.f_256948_);
        Holder.Reference poolKS = structureTemplatePoolHolder.m_255043_(KPools.KISMET_STRUCTURE);
        context.m_255272_(KISMET_STRUCTURE, (Object)new KismetStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(Tags.Biomes.IS_UNDERGROUND), mobSpawnsBox, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY), (Holder<StructureTemplatePool>)poolKS, Optional.empty(), 1, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)50)), Optional.empty(), 80));
    }
}

