/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.datagen;

import com.scouter.kismet.blocks.KBlocks;
import com.scouter.kismet.entity.KEntities;
import com.scouter.kismet.items.KItems;
import com.scouter.kismet.sounds.KSoundEvents;
import com.scouter.kismet.tabs.KTabs;
import com.scouter.kismet.util.KTextUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class LanguageGenerator
extends LanguageProvider {
    public LanguageGenerator(PackOutput output) {
        super(output, "kismet", "en_us");
    }

    protected void addTranslations() {
        this.addTabName((CreativeModeTab)KTabs.TAB.get(), "Kismet");
        KBlocks.AUTO_TRANSLATE.forEach(this::forBlock);
        KItems.AUTO_TRANSLATE.forEach(this::forItem);
        this.addBETranslatable("container.kismet_barrel", "Kismet Barrel");
        this.add((EntityType)KEntities.BYTE.get(), "Byte");
        this.add((EntityType)KEntities.KILOBYTE.get(), "Kilobyte");
        this.add((EntityType)KEntities.MEGABYTE.get(), "Megabyte");
        this.add("death.attack.kismet.electric_shock", "%1$s was too grounded for this world");
        this.add("death.attack.kismet.electric_shock.player", "%1$s short-circuited thanks to %2$s");
        this.add("item.kismet.descriptionitem.hover_info", "Press shift for more info!");
        this.add("item.kismet.synthetic_organ.description", "Consume this to gain cybernetic abilities, keep consuming to upgrade further");
        this.add("item.kismet.organ_regrower.description", "Consume this to lose cybernetic abilities and become human once more");
        this.add("item.kismet.kismet_battery.description", "Consume this to recharge your battery");
        this.add("kismet.battery.not_enough", "You do not have enough charge to perform an attack!");
        this.add("kismet.key.special_ability", "Electric attack keybind!");
        this.add("kismet.critical_damage.info", "Prevented critical damage!");
        this.add("gui'.kismet.recipebook.toggleRecipes.charging", "Charging");
        this.add("container.kismet.charger", "Charger");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.KISMET_HURT, "Mechanical hurt");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.KISMET_DEATH, "Mechanical death");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.BYTE_IDLE, "Byte zooming");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.KILOBYTE_IDLE, "Kilobyte watching");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.KILOBYTE_ATTACK, "Kilobyte swirling");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.KILOBYTE_CHARGE, "Kilobyte charging");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.MEGABYTE_IDLE, "Megabyte zoning");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.MEGABYTE_ATTACK, "Megabyte stomping");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.MEGABYTE_SLAM, "Megabyte slamming");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.ELECTRIC_ATTACK, "Electric attack");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.EXTRA_JUMP, "Poof");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.ORGAN_REGROWTH, "Crack crack");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.SYNTHETIC_ORGAN_ACTIVATION, "Wrrrrrrr");
        this.addSound((Supplier<? extends SoundEvent>)KSoundEvents.CHARGER_CHARGING, "Charge-Charge...");
        this.add("kismet.advancement.root", "A tale from the future");
        this.add("kismet.advancement.root.desc", "Enter a kismet structure");
        this.add("kismet.advancement.craft_charger", "Charging?!");
        this.add("kismet.advancement.craft_charger.desc", "Craft a kismet charger");
        this.add("kismet.advancement.eat_synthetic_organ", "I feel power!");
        this.add("kismet.advancement.eat_synthetic_organ.desc", "Eat a synthetic organ");
        this.add("kismet.advancement.eat_organ_regrower", "I feel... normal");
        this.add("kismet.advancement.eat_organ_regrower.desc", "Eat an organ regrower");
        this.add("kismet.advancement.mechanical_ascension", "Mechanical ascension!");
        this.add("kismet.advancement.mechanical_ascension.desc", "Eat 5 synthetic organs and obtain mechanical ascension");
        this.add("kismet.advancement.kill_all_kismet_enemies", "Defender of the past");
        this.add("kismet.advancement.kill_all_kismet_enemies.desc", "Kill all invading enemies once");
    }

    public String m_6055_() {
        return "kismet Languages: en_us";
    }

    public void addBETranslatable(String beName, String name) {
        this.add("kismet.blockentity." + beName, name);
    }

    public void addSound(Supplier<? extends SoundEvent> key, String name) {
        this.add("kismet.sound.subtitle." + key.get().m_11660_().m_135815_(), name);
    }

    public void addTabName(CreativeModeTab key, String name) {
        this.add(key.m_40786_().getString(), name);
    }

    public void add(CreativeModeTab key, String name) {
        this.add(key.m_40786_().getString(), name);
    }

    public void addPotion(Supplier<? extends Potion> key, String name, String regName) {
        this.add(key.get(), name, regName);
    }

    private void addEnchantmentWithDesc(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, this.formatEnchantment(name));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    private String formatEnchantment(String path) {
        return WordUtils.capitalizeFully((String)path.replace("_", " ")).replace("Of ", "of ");
    }

    public void add(Potion key, String name, String regName) {
        this.add("registerItemNoLang.minecraft.potion.effect." + regName, name);
        this.add("registerItemNoLang.minecraft.splash_potion.effect." + regName, "Splash " + name);
        this.add("registerItemNoLang.minecraft.lingering_potion.effect." + regName, "Lingering " + name);
    }

    protected void forBlock(Supplier<? extends Block> block) {
        this.addBlock(block, KTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_()));
    }

    protected void forItem(Supplier<? extends Item> item) {
        this.addItem(item, KTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get())).m_135815_()));
    }

    protected void forEntity(Supplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, KTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entity.get())).m_135815_()));
    }
}

