/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.datagen;

import com.scouter.kismet.blocks.KBlocks;
import com.scouter.kismet.items.KItems;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "kismet", existingFileHelper);
    }

    protected void registerModels() {
        this.singleTex(KItems.CONGLOMERATED_ORGAN);
        this.singleTex(KItems.EMPTY_BATTERY);
        this.singleTex(KItems.KISMET_BATTERY);
        this.singleTex(KItems.KISMET_PLATING);
        this.singleTex(KItems.SYNTHETIC_ORGAN);
        this.singleTex(KItems.ORGAN_REGROWER);
        this.blockItemWithItemTexture((Supplier<? extends Block>)KBlocks.KISMET_DOOR);
        this.singleTexBlock(KBlocks.KISMET_BARS);
        this.basicBlockItem((Supplier<? extends Block>)KBlocks.KISMET_PLATE_SLAB);
        this.buttonBlockItem((Supplier<? extends Block>)KBlocks.KISMET_PLATE_BUTTON, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.pressurePlate(ItemModelGenerator.name((Block)KBlocks.KISMET_PLATE_PRESSURE_PLATE.get()), ItemModelGenerator.modBlockLocation(ItemModelGenerator.name((Block)KBlocks.KISMET_PLATE_BLOCK.get())));
        this.wallBlockItem((Supplier<? extends Block>)KBlocks.KISMET_PLATE_WALL, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.basicBlockItem((Supplier<? extends Block>)KBlocks.KISMET_PLATE_STAIRS);
        this.toBlock(KBlocks.BRAIN);
        for (Item item : BuiltInRegistries.f_257033_) {
            if (!(item instanceof SpawnEggItem) || !Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135827_().equals("kismet")) continue;
            ((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/template_spawn_egg")));
        }
    }

    public static String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private void buttonBlockItem(Supplier<? extends Block> blockForItem, Supplier<? extends Block> blockForTexture) {
        this.buttonInventory(ItemModelGenerator.name(blockForItem.get()), ItemModelGenerator.modBlockLocation(ItemModelGenerator.name(blockForTexture.get())));
    }

    private void wallBlockItem(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.wallInventory(ItemModelGenerator.name(block.get()), ItemModelGenerator.modBlockLocation(ItemModelGenerator.name(blockForTexture.get())));
    }

    private void blockItemWithItemTexture(Supplier<? extends Block> blockForItem) {
        this.basicItem(blockForItem.get().m_5456_());
    }

    private void toBlock(RegistryObject<Block> b) {
        this.toBlockModel(b, b.getId().m_135815_());
    }

    private void basicBlockItem(Supplier<? extends Block> blockForItem) {
        this.withExistingParent(ItemModelGenerator.name(blockForItem.get()), ItemModelGenerator.modBlockLocation(ItemModelGenerator.name(blockForItem.get())));
    }

    private void toBlockModel(RegistryObject<Block> b, String model) {
        this.toBlockModel(b, ItemModelGenerator.prefix("block/" + model));
    }

    private void toBlockModel(RegistryObject<Block> b, ResourceLocation model) {
        this.withExistingParent(b.getId().m_135815_(), model);
    }

    private ItemModelBuilder singleTexBlock(RegistryObject<Block> block) {
        return this.generated(block.getId().m_135815_(), ItemModelGenerator.prefix("block/" + block.getId().m_135815_()));
    }

    private ItemModelBuilder singleTex(RegistryObject<Item> item) {
        return this.generated(item.getId().m_135815_(), ItemModelGenerator.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation("kismet", name);
    }

    public static ResourceLocation modBlockLocation(String path) {
        return ItemModelGenerator.prefix("block/" + path);
    }

    public static ResourceLocation modItemLocation(String path) {
        return ItemModelGenerator.prefix("item/" + path);
    }

    public static ResourceLocation vanillaBlockLocation(String path) {
        return new ResourceLocation("block/" + path);
    }

    public static ResourceLocation vanillaItemLocation(String path) {
        return new ResourceLocation("item/" + path);
    }
}

