/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.datagen;

import com.scouter.kismet.datagen.AdvancementProvider;
import com.scouter.kismet.datagen.BlockStateGenerator;
import com.scouter.kismet.datagen.BlockTagGenerator;
import com.scouter.kismet.datagen.ItemModelGenerator;
import com.scouter.kismet.datagen.ItemTagGenerator;
import com.scouter.kismet.datagen.KDamageTypeTagProvider;
import com.scouter.kismet.datagen.KEntityTagProvider;
import com.scouter.kismet.datagen.LanguageGenerator;
import com.scouter.kismet.datagen.LootGenerator;
import com.scouter.kismet.datagen.RecipeGenerator;
import com.scouter.kismet.datagen.RegistryDataGenerator;
import com.scouter.kismet.datagen.SoundsDefinitionsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kismet", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Datagenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)LootGenerator.create(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LanguageGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, lookupProvider);
        CompletableFuture customLookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        BlockTagGenerator blockTagGenerator = (BlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGenerator(packOutput, customLookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, customLookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new KEntityTagProvider(packOutput, customLookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new KDamageTypeTagProvider(packOutput, customLookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SoundsDefinitionsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(packOutput, customLookupProvider, existingFileHelper));
    }
}

