/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.datagen;

import com.scouter.kismet.Kismet;
import com.scouter.kismet.blocks.ChangeMiddleBlock;
import com.scouter.kismet.blocks.KBlocks;
import com.scouter.kismet.blocks.properties.TriBlockProperties;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "kismet", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.cubeAllBlock(KBlocks.KISMET_PLATE_BLOCK);
        this.triColumnBlock(KBlocks.KISMET_COG_BLOCK);
        this.cubeAllBlock(KBlocks.KISMET_LAMP);
        this.cubeAllBlock(KBlocks.POLISHED_KISMET);
        this.cubeAllBlock(KBlocks.CHISELED_KISMET);
        this.trapdoorCutout(KBlocks.KISMET_VENT);
        this.slab((Supplier<? extends Block>)KBlocks.KISMET_PLATE_SLAB, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.wall((Supplier<? extends Block>)KBlocks.KISMET_PLATE_WALL, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.pressurePlateBlock((Supplier<? extends Block>)KBlocks.KISMET_PLATE_PRESSURE_PLATE, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.buttonBlock((Supplier<? extends Block>)KBlocks.KISMET_PLATE_BUTTON, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.stairs((Supplier<? extends Block>)KBlocks.KISMET_PLATE_STAIRS, (Supplier<? extends Block>)KBlocks.KISMET_PLATE_BLOCK);
        this.barsLike(KBlocks.KISMET_BARS);
        this.doorBlockCutout((Supplier<? extends Block>)KBlocks.KISMET_DOOR);
        this.pillar(KBlocks.KISMET_PILLAR, KBlocks.POLISHED_KISMET);
        this.facedCubeHorizontal(KBlocks.BRAIN);
        this.barrelLike(KBlocks.KISMET_BARREL);
        this.chargerLike(KBlocks.CHARGER);
    }

    private void itemModel(RegistryObject<Block> block) {
        this.itemModels().withExistingParent(BlockStateGenerator.getItemName((ItemLike)block.get()), this.blockTexture((Block)block.get()));
    }

    private void generatedItem(ItemLike item, TextureFolder folder) {
        String name = BlockStateGenerator.getItemName(item);
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, "item/generated")).texture("layer0", this.modLoc(folder.format(name)));
    }

    private void cubeAllBlock(RegistryObject<Block> block) {
        this.simpleBlock((Block)block.get());
        this.itemModel(block);
    }

    private void cubeAllBlockCutout(RegistryObject<Block> block) {
        this.cubeAllBlockWithRenderType(block, "cutout");
    }

    private void cubeAllBlockWithRenderType(RegistryObject<Block> block, String renderType) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlockStateGenerator.getBlockName((Block)block.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/cube_all")))).renderType(renderType)).texture("all", this.blockTexture((Block)block.get())));
        this.itemModel(block);
    }

    private void stairs(RegistryObject<Block> stairs, ResourceLocation texture) {
        this.stairsBlock((StairBlock)stairs.get(), texture);
        this.itemModel(stairs);
    }

    private void buttonBlock(Supplier<? extends Block> block) {
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture(block.get()));
    }

    private void stairs(Supplier<? extends Block> block) {
        this.stairsBlock((StairBlock)block.get(), this.blockTexture(block.get()));
    }

    private void stairs(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.stairsBlock((StairBlock)block.get(), this.blockTexture(blockForTexture.get()));
    }

    private void buttonBlock(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture(blockForTexture.get()));
    }

    private void doorBlock(Supplier<? extends Block> block) {
        this.doorBlock((DoorBlock)block.get(), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(block.get()) + "_bottom"), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(block.get()) + "_top"));
    }

    private void doorBlockCutout(Supplier<? extends Block> block) {
        this.doorBlockWithRenderType(block, "cutout");
    }

    private void doorBlockWithRenderType(Supplier<? extends Block> block, String rendertype) {
        this.doorBlockWithRenderType((DoorBlock)block.get(), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(block.get()) + "_bottom"), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(block.get()) + "_top"), rendertype);
    }

    private void pressurePlateBlock(Supplier<? extends Block> block) {
        this.pressurePlateBlock((PressurePlateBlock)block.get(), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(block.get())));
    }

    private void pressurePlateBlock(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.pressurePlateBlock((PressurePlateBlock)block.get(), BlockStateGenerator.modBlockLocation(BlockStateGenerator.name(blockForTexture.get())));
    }

    private void wall(Supplier<? extends Block> block) {
        this.wallBlock((WallBlock)block.get(), this.blockTexture(block.get()));
    }

    private void wall(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.wallBlock((WallBlock)block.get(), this.blockTexture(blockForTexture.get()));
    }

    private void slab(Supplier<? extends Block> block) {
        this.slabBlock((SlabBlock)block.get(), this.blockTexture(block.get()), this.blockTexture(block.get()));
    }

    private void slab(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture) {
        this.slabBlock((SlabBlock)block.get(), this.blockTexture(blockForTexture.get()), this.blockTexture(blockForTexture.get()));
    }

    private void slab(RegistryObject<Block> slab, ResourceLocation texture) {
        this.slabBlock((SlabBlock)slab.get(), texture, texture);
        this.itemModel(slab);
    }

    private void wall(RegistryObject<Block> wall, ResourceLocation texture) {
        this.wallBlock((WallBlock)wall.get(), texture);
        this.itemModels().wallInventory(BlockStateGenerator.getItemName((ItemLike)wall.get()), texture);
    }

    private void simpleCross(RegistryObject<Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BlockStateGenerator.getItemName((ItemLike)block.get()), this.blockTexture((Block)block.get()))).renderType("cutout"));
    }

    private void trapdoor(RegistryObject<Block> trapdoor) {
        this.trapdoorBlock((TrapDoorBlock)trapdoor.get(), this.blockTexture((Block)trapdoor.get()), true);
        this.itemModels().withExistingParent(BlockStateGenerator.getItemName((ItemLike)trapdoor.get()), this.modLoc("block/" + BlockStateGenerator.getItemName((ItemLike)trapdoor.get()) + "_bottom"));
    }

    private void trapdoorCutout(RegistryObject<Block> trapdoor) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)trapdoor.get(), this.blockTexture((Block)trapdoor.get()), true, "cutout");
        this.itemModels().withExistingParent(BlockStateGenerator.getItemName((ItemLike)trapdoor.get()), this.modLoc("block/" + BlockStateGenerator.getItemName((ItemLike)trapdoor.get()) + "_bottom"));
    }

    private void door(RegistryObject<Block> door) {
        String name = BlockStateGenerator.getItemName((ItemLike)door.get());
        this.doorBlock((DoorBlock)door.get(), name.replace("_door", ""), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top"));
        this.generatedItem((ItemLike)door.get(), TextureFolder.ITEM);
    }

    private void doorCutout(RegistryObject<Block> door) {
        String name = BlockStateGenerator.getItemName((ItemLike)door.get());
        this.doorBlockWithRenderType((DoorBlock)door.get(), name.replace("_door", ""), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top"), "cutout");
        this.generatedItem((ItemLike)door.get(), TextureFolder.ITEM);
    }

    private void pillar(RegistryObject<Block> pillar) {
        this.axisBlock((RotatedPillarBlock)pillar.get(), this.blockTexture((Block)pillar.get()), this.modLoc("block/" + BlockStateGenerator.getItemName((ItemLike)pillar.get()) + "_top"));
        this.itemModel(pillar);
    }

    private void pillar(RegistryObject<Block> pillar, RegistryObject<Block> pillar2) {
        this.axisBlock((RotatedPillarBlock)pillar.get(), this.blockTexture((Block)pillar.get()), this.modLoc("block/" + BlockStateGenerator.getItemName((ItemLike)pillar2.get())));
        this.itemModel(pillar);
    }

    public void directionalBlock(RegistryObject<Block> block, ResourceLocation sideTexture, ResourceLocation bottomTexture) {
        this.directionalBlock((Block)block.get(), (ModelFile)this.models().cubeColumn(BlockStateGenerator.getBlockName((Block)block.get()), sideTexture, bottomTexture));
        this.itemModel(block);
    }

    public void directionalBlock(RegistryObject<Block> block) {
        String name = BlockStateGenerator.getItemName((ItemLike)block.get());
        this.directionalBlock(block, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_top"));
    }

    public void directionalBlock(RegistryObject<Block> block, RegistryObject<Block> block2) {
        String name = BlockStateGenerator.getItemName((ItemLike)block.get());
        String name2 = BlockStateGenerator.getItemName((ItemLike)block2.get());
        this.directionalBlock(block, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name2));
    }

    private void facedCubeHorizontal(RegistryObject<Block> blockRegistryObject) {
        String name = BlockStateGenerator.name((Block)blockRegistryObject.get());
        this.facedCubeHorizontal((Block)blockRegistryObject.get(), name, BlockStateGenerator.modBlockLocation("brain_bottom"), BlockStateGenerator.modBlockLocation("brain_top"), BlockStateGenerator.modBlockLocation("brain_back"), BlockStateGenerator.modBlockLocation("brain_front"), BlockStateGenerator.modBlockLocation("brain_left"), BlockStateGenerator.modBlockLocation("brain_right"));
    }

    private void facedCubeHorizontal(Block block, String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation west, ResourceLocation east) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/cube"))).texture("particle", north)).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("west", west)).texture("east", east);
        this.horizontalBlock(block, (ModelFile)model);
    }

    public void fullCubePerFaceRotatable(RegistryObject<Block> ro) {
        Block block = (Block)ro.get();
        ResourceLocation base = this.blockTexture(block);
        ResourceLocation north = BlockStateGenerator.withSuffix(base, "_back");
        ResourceLocation east = BlockStateGenerator.withSuffix(base, "_left");
        ResourceLocation south = BlockStateGenerator.withSuffix(base, "_front");
        ResourceLocation west = BlockStateGenerator.withSuffix(base, "_right");
        ResourceLocation up = BlockStateGenerator.withSuffix(base, "_top");
        ResourceLocation down = BlockStateGenerator.withSuffix(base, "_bottom");
        ModelFile modelFile = this.buildPerFaceCubeModel(BlockStateGenerator.getBlockName(block), north, east, south, west, up, down);
        this.horizontalFacingBlockstate(block, modelFile);
    }

    public void chargerLike(RegistryObject<Block> ro) {
        Block block = (Block)ro.get();
        String name = BlockStateGenerator.getBlockName(block);
        BlockModelBuilder offModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, this.mcLoc("block/orientable_with_bottom"))).texture("side", BlockStateGenerator.modBlockLocation(name + "_side"))).texture("top", BlockStateGenerator.modBlockLocation(name + "_top"))).texture("bottom", BlockStateGenerator.modBlockLocation(name + "_bottom"))).texture("front", BlockStateGenerator.modBlockLocation(name + "_front"))).texture("particle", BlockStateGenerator.modBlockLocation(name + "_side"));
        BlockModelBuilder onModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + "_lit", this.mcLoc("block/orientable_with_bottom"))).texture("side", BlockStateGenerator.modBlockLocation(name + "_side"))).texture("top", BlockStateGenerator.modBlockLocation(name + "_top"))).texture("bottom", BlockStateGenerator.modBlockLocation(name + "_bottom"))).texture("front", BlockStateGenerator.modBlockLocation(name + "_front_lit"))).texture("particle", BlockStateGenerator.modBlockLocation(name + "_side"));
        ModelFile.ExistingModelFile off = new ModelFile.ExistingModelFile(this.modLoc("block/" + name), this.existingFileHelper);
        ModelFile.ExistingModelFile on = new ModelFile.ExistingModelFile(this.modLoc("block/" + name + "_lit"), this.existingFileHelper);
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateGenerator.lambda$chargerLike$0((ModelFile)on, (ModelFile)off, arg_0));
        this.simpleBlockItem(block, (ModelFile)off);
    }

    public ModelFile buildPerFaceCubeModel(String name, ResourceLocation left, ResourceLocation right, ResourceLocation front, ResourceLocation back, ResourceLocation top, ResourceLocation bottom) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, this.mcLoc("block/cube"))).texture("north", front)).texture("east", right)).texture("south", back)).texture("west", left)).texture("up", top)).texture("down", bottom)).texture("particle", front);
        return new ModelFile.ExistingModelFile(this.modLoc("block/" + name), this.existingFileHelper);
    }

    public void horizontalFacingBlockstate(Block block, ModelFile model) {
        VariantBlockStateBuilder vb = this.getVariantBuilder(block);
        vb.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile(model).uvLock(true).build());
        vb.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile(model).rotationY(90).uvLock(true).build());
        vb.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile(model).rotationY(180).uvLock(true).build());
        vb.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile(model).rotationY(270).uvLock(true).build());
    }

    public void barrelLike(RegistryObject<Block> block) {
        ResourceLocation base = this.blockTexture((Block)block.get());
        this.barrelLike((Block)block.get(), BlockStateGenerator.withSuffix(base, "_side"), BlockStateGenerator.withSuffix(base, "_bottom"), BlockStateGenerator.withSuffix(base, "_top"), BlockStateGenerator.withSuffix(base, "_open"));
    }

    public void barrelLike(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, ResourceLocation topOpen) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        BlockModelBuilder closedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, this.mcLoc("block/cube_bottom_top"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("particle", side);
        BlockModelBuilder openModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + "_open", this.mcLoc("block/cube_bottom_top"))).texture("side", side)).texture("bottom", bottom)).texture("top", topOpen)).texture("particle", side);
        ModelFile.ExistingModelFile closed = new ModelFile.ExistingModelFile(this.modLoc("block/" + name), this.existingFileHelper);
        ModelFile.ExistingModelFile open = new ModelFile.ExistingModelFile(this.modLoc("block/" + name + "_open"), this.existingFileHelper);
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateGenerator.lambda$barrelLike$1((ModelFile)open, (ModelFile)closed, arg_0));
        this.simpleBlockItem(block, (ModelFile)closed);
    }

    public void barsLike(RegistryObject<Block> block) {
        String name = BlockStateGenerator.name((Block)block.get());
        BarsModelSet set = this.makeBarsModels(name, this.blockTexture((Block)block.get()));
        MultiPartBlockStateBuilder b = this.getMultipartBuilder((Block)block.get());
        b.part().modelFile(set.postEnds).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.post).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.cap).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.cap).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.capAlt).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.capAlt).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.side).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.side).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.sideAlt).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)b.part().modelFile(set.sideAlt).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
    }

    private BarsModelSet makeBarsModels(String baseName, ResourceLocation texture) {
        BlockModelBuilder postEnds = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_post_ends", this.mcLoc("block/iron_bars_post_ends"));
        BlockModelBuilder post = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_post", this.mcLoc("block/iron_bars_post"));
        BlockModelBuilder cap = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_cap", this.mcLoc("block/iron_bars_cap"));
        BlockModelBuilder capAlt = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_cap_alt", this.mcLoc("block/iron_bars_cap_alt"));
        BlockModelBuilder side = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_side", this.mcLoc("block/iron_bars_side"));
        BlockModelBuilder sideAlt = (BlockModelBuilder)this.models().withExistingParent("block/" + baseName + "_side_alt", this.mcLoc("block/iron_bars_side_alt"));
        BlockStateGenerator.setBarsLikeTextures(postEnds, texture);
        BlockStateGenerator.setBarsLikeTextures(post, texture);
        BlockStateGenerator.setBarsLikeTextures(cap, texture);
        BlockStateGenerator.setBarsLikeTextures(capAlt, texture);
        BlockStateGenerator.setBarsLikeTextures(side, texture);
        BlockStateGenerator.setBarsLikeTextures(sideAlt, texture);
        return new BarsModelSet((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_post_ends"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_post"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_cap"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_cap_alt"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_side"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/" + baseName + "_side_alt"), this.existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("item/" + baseName), this.existingFileHelper));
    }

    private static void setBarsLikeTextures(ModelBuilder<?> b, ResourceLocation texture) {
        b.texture("bars", texture).texture("pane", texture).texture("edge", texture).texture("particle", texture).renderType("cutout");
    }

    private void triColumnBlock(RegistryObject<Block> blockRegistryObject) {
        this.triColumnBlock((Block)blockRegistryObject.get(), BlockStateGenerator.name((Block)blockRegistryObject.get()));
    }

    private void triColumnBlock(Block block, String base) {
        ModelBuilder modelNone = this.models().cubeBottomTop(base + "_single", BlockStateGenerator.modBlockLocation(base), BlockStateGenerator.modBlockLocation(base), BlockStateGenerator.modBlockLocation(base));
        ModelBuilder modelBottom = this.models().cubeBottomTop(base + "_bottom", BlockStateGenerator.modBlockLocation(base + "_bottom"), BlockStateGenerator.modBlockLocation(base), BlockStateGenerator.modBlockLocation(base));
        ModelBuilder modelMiddle = this.models().cubeBottomTop(base + "_middle", BlockStateGenerator.modBlockLocation(base + "_middle"), BlockStateGenerator.modBlockLocation(base), BlockStateGenerator.modBlockLocation(base));
        ModelBuilder modelTop = this.models().cubeBottomTop(base + "_top", BlockStateGenerator.modBlockLocation(base + "_top"), BlockStateGenerator.modBlockLocation(base), BlockStateGenerator.modBlockLocation(base));
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateGenerator.lambda$triColumnBlock$2((ModelFile)modelNone, (ModelFile)modelBottom, (ModelFile)modelMiddle, (ModelFile)modelTop, arg_0));
        this.simpleBlockItem(block, (ModelFile)modelNone);
    }

    public static String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public static String name(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    private static String getItemName(ItemLike item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_();
    }

    private static String getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public static ResourceLocation modBlockLocation(String path) {
        return Kismet.prefix("block/" + path);
    }

    public static ResourceLocation modItemLocation(String path) {
        return Kismet.prefix("item/" + path);
    }

    public static ResourceLocation vanillaBlockLocation(String path) {
        return new ResourceLocation("block/" + path);
    }

    public static ResourceLocation vanillaItemLocation(String path) {
        return new ResourceLocation("item/" + path);
    }

    private static ResourceLocation withSuffix(ResourceLocation base, String suffix) {
        return new ResourceLocation(base.m_135827_(), base.m_135815_() + suffix);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$triColumnBlock$2(ModelFile modelNone, ModelFile modelBottom, ModelFile modelMiddle, ModelFile modelTop, BlockState state) {
        TriBlockProperties tri = (TriBlockProperties)((Object)state.m_61143_(ChangeMiddleBlock.TRI_STATE));
        ModelFile chosen = switch (tri) {
            default -> throw new IncompatibleClassChangeError();
            case TriBlockProperties.NONE -> modelNone;
            case TriBlockProperties.BOTTOM -> modelBottom;
            case TriBlockProperties.MIDDLE -> modelMiddle;
            case TriBlockProperties.TOP -> modelTop;
        };
        return ConfiguredModel.builder().modelFile(chosen).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$barrelLike$1(ModelFile open, ModelFile closed, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        int x = 0;
        int y = 0;
        switch (facing) {
            case DOWN: {
                x = 180;
                break;
            }
            case NORTH: {
                x = 90;
                break;
            }
            case SOUTH: {
                x = 270;
                break;
            }
            case EAST: {
                x = 90;
                y = 90;
                break;
            }
            case WEST: {
                x = 90;
                y = 270;
                break;
            }
        }
        return ConfiguredModel.builder().modelFile(isOpen ? open : closed).rotationX(x).rotationY(y).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chargerLike$0(ModelFile on, ModelFile off, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean lit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
        int rotY = switch (dir) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
        return ConfiguredModel.builder().modelFile(lit ? on : off).rotationY(rotY).build();
    }

    private static enum TextureFolder {
        ITEM,
        BLOCK;


        public String format(String itemName) {
            return this.name().toLowerCase() + "/" + itemName;
        }
    }

    private record BarsModelSet(ModelFile postEnds, ModelFile post, ModelFile cap, ModelFile capAlt, ModelFile side, ModelFile sideAlt, ModelFile inventory) {
    }
}

