/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.data;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.scouter.kismet.data.PlayerData;
import com.scouter.kismet.network.KNetwork;
import com.scouter.kismet.network.PlayerDataS2CPacket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public class PlayerDataStore
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String DATA_NAME = "kismet_player_data";
    private Map<UUID, PlayerData> players = new ConcurrentHashMap<UUID, PlayerData>();
    public static final Codec<Map<UUID, PlayerData>> MAPPER = Codec.unboundedMap((Codec)UUIDUtil.f_260719_, PlayerData.CODEC);

    public PlayerDataStore() {
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag compound;
        Tag dataTag = (Tag)MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.players).resultOrPartial(msg -> LOGGER.error("[SavedData] Error saving data: {}", msg)).orElse(new CompoundTag());
        if (dataTag instanceof CompoundTag && !(compound = (CompoundTag)dataTag).m_128456_()) {
            tag.m_128365_("data", (Tag)compound);
        }
        return tag;
    }

    public PlayerDataStore(CompoundTag tag) {
        Map map = tag.m_128441_("data") ? MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("data")).resultOrPartial(msg -> LOGGER.error("[SavedData] Error loading data: {}", msg)).orElseGet(ConcurrentHashMap::new) : new ConcurrentHashMap();
        this.players = new ConcurrentHashMap<UUID, PlayerData>(map);
    }

    public static PlayerDataStore get(Level level) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        ServerLevel overworld = server.m_7654_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (PlayerDataStore)storage.m_164861_(PlayerDataStore::new, PlayerDataStore::new, DATA_NAME);
    }

    public void m_77762_() {
        super.m_77762_();
    }

    public Map<UUID, PlayerData> view() {
        return this.players;
    }

    public PlayerData get(UUID id) {
        return this.getOrCreate(id);
    }

    public PlayerData getOrCreate(UUID id) {
        PlayerData existing = this.players.get(id);
        if (existing != null) {
            return existing;
        }
        PlayerData created = PlayerData.empty();
        PlayerData prev = this.players.putIfAbsent(id, created);
        return prev != null ? prev : created;
    }

    private static void syncOne(ServerLevel level, Player player, PlayerData data) {
        ServerPlayer sp = level.m_7654_().m_6846_().m_11259_(player.m_20148_());
        if (sp == null) {
            return;
        }
        CompoundTag dataTag = new CompoundTag();
        CompoundTag payload = (CompoundTag)PlayerData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)data).result().orElseGet(CompoundTag::new);
        dataTag.m_128365_("data", (Tag)payload);
        KNetwork.sendToPlayer(new PlayerDataS2CPacket(dataTag), sp);
    }

    public void putAndSync(Player player, PlayerData data, ServerLevel level) {
        this.players.put(player.m_20148_(), data);
        this.m_77762_();
        PlayerDataStore.syncOne(level, player, data);
    }

    public void put(UUID id, PlayerData data) {
        this.players.put(id, data);
        this.m_77762_();
    }

    public void remove(UUID id) {
        if (this.players.remove(id) != null) {
            this.m_77762_();
        }
    }
}

