/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.data;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.scouter.kismet.data.PlayerData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.slf4j.Logger;

public class PlayerDataClientCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final PlayerDataClientCache INSTANCE = new PlayerDataClientCache();
    private PlayerData snapshot = PlayerData.empty();

    public static PlayerDataClientCache get() {
        return INSTANCE;
    }

    public void applySync(CompoundTag payload) {
        if (!payload.m_128441_("data")) {
            this.snapshot = PlayerData.empty();
            return;
        }
        DataResult res = PlayerData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)payload.m_128469_("data"));
        this.snapshot = res.resultOrPartial(msg -> LOGGER.error("[ClientCache] Error parsing sync: {}", msg)).orElseGet(PlayerData::empty);
    }

    public PlayerData snapshot() {
        return this.snapshot;
    }
}

