/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.kismet.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record PlayerData(int kismetLevel, int doubleJumpCount, int eaten, int batteryCharge, long lastBatteryDrainTick, long lastAttackTick, long lastHungerDrainTick) {
    public static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("kismet_level").forGetter(PlayerData::kismetLevel), (App)Codec.INT.fieldOf("double_jump_count").forGetter(PlayerData::doubleJumpCount), (App)Codec.INT.fieldOf("eaten").forGetter(PlayerData::eaten), (App)Codec.INT.fieldOf("battery_charge").forGetter(PlayerData::batteryCharge), (App)Codec.LONG.fieldOf("last_battery_drain_tick").forGetter(PlayerData::lastBatteryDrainTick), (App)Codec.LONG.fieldOf("last_attack_tick").forGetter(PlayerData::lastAttackTick), (App)Codec.LONG.fieldOf("last_hunger_drain_tick").forGetter(PlayerData::lastAttackTick)).apply((Applicative)i, PlayerData::new));

    public static PlayerData empty() {
        return new PlayerData(0, 0, 0, 0, 0L, 0L, 0L);
    }

    public PlayerData withBatteryCharge(int v) {
        return new PlayerData(this.kismetLevel, this.doubleJumpCount, this.eaten, Math.max(0, Math.min(100, v)), this.lastBatteryDrainTick, this.lastAttackTick, this.lastHungerDrainTick);
    }

    public PlayerData withLastDrain(long t) {
        return new PlayerData(this.kismetLevel, this.doubleJumpCount, this.eaten, this.batteryCharge, t, this.lastAttackTick, this.lastHungerDrainTick);
    }

    public PlayerData withLastAttack(long t) {
        return new PlayerData(this.kismetLevel, this.doubleJumpCount, this.eaten, this.batteryCharge, this.lastBatteryDrainTick, t, this.lastHungerDrainTick);
    }

    public PlayerData withLastHungerDrain(long t) {
        return new PlayerData(this.kismetLevel, this.doubleJumpCount, this.eaten, this.batteryCharge, this.lastAttackTick, this.lastAttackTick, t);
    }
}

