/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TargetRenderer
implements BlockEntityRenderer<TargetBlockEntity> {
    private static final String UPPER_NAME = "target_upper";
    private static final String HEAD_NAME = "head";

    public TargetRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.TARGET_MODEL_LOCATION);
    }

    public void render(TargetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TargetRenderer.getModel().ifPresent(model -> {
            BlockState blockState = blockEntity.m_58900_();
            Direction facing = (Direction)blockState.m_61143_((Property)TargetBlock.FACING);
            BedrockPart headModel = model.getNode(HEAD_NAME);
            BedrockPart upperModel = model.getNode(UPPER_NAME);
            float deg = -Mth.m_14179_((float)partialTick, (float)blockEntity.oRot, (float)blockEntity.rot);
            upperModel.xRot = (float)Math.toRadians(deg);
            headModel.visible = false;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.225, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(facing.m_122416_() * 90)));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            poseStack.m_85837_(0.0, -1.275, 0.0125);
            RenderType renderType = RenderType.m_110473_((ResourceLocation)InternalAssetLoader.TARGET_TEXTURE_LOCATION);
            model.render(poseStack, ItemDisplayContext.NONE, renderType, combinedLightIn, combinedOverlayIn);
            if (blockEntity.getOwner() != null) {
                poseStack.m_85837_(0.0, 1.25, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(deg));
                Minecraft minecraft = Minecraft.m_91087_();
                Map map = minecraft.m_91109_().m_118815_(blockEntity.getOwner());
                ResourceLocation skin = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)blockEntity.getOwner()));
                headModel.visible = true;
                RenderType skullRenderType = RenderType.m_110452_((ResourceLocation)skin);
                headModel.render(poseStack, ItemDisplayContext.NONE, bufferIn.m_6299_(skullRenderType), combinedLightIn, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
        });
    }

    public int m_142163_() {
        return (Integer)RenderConfig.TARGET_RENDER_DISTANCE.get();
    }

    public boolean shouldRenderOffScreen(TargetBlockEntity blockEntity) {
        return true;
    }
}

