/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.util;

import com.xinian.tickaccelerate.TickAccelerate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TPSUtil {
    private static final DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static final DecimalFormat dfMissedTicks = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ROOT));
    public static final double TPS_GOOD_THRESHOLD = 15.0;
    public static final double TPS_WARNING_THRESHOLD = 10.0;

    public static String colorizeTPS(double tps, boolean format) {
        if (tps > 15.0) {
            return "\u00a7a" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
        }
        if (tps > 10.0) {
            return "\u00a7e" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
        }
        return "\u00a7c" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
    }

    public static String formatTPS(double tps) {
        return df.format(tps);
    }

    public static String formatMissedTicks(double missedTicks) {
        return dfMissedTicks.format(missedTicks);
    }

    public static float tt20(float ticks, boolean limitZero, double tpsMultiplier, @Nullable ResourceLocation resourceLocation) {
        float newTicks = (float)TPSUtil.rawTT20(ticks, tpsMultiplier, resourceLocation);
        Integer customTickCap = TickAccelerate.config.getCustomTickCap(resourceLocation);
        if (customTickCap != null && customTickCap > 0) {
            newTicks = Math.min(newTicks, (float)customTickCap.intValue());
        }
        if (limitZero) {
            return newTicks > 0.0f ? newTicks : 1.0f;
        }
        return newTicks;
    }

    public static int tt20(int ticks, boolean limitZero, double tpsMultiplier, @Nullable ResourceLocation resourceLocation) {
        int newTicks = (int)Math.ceil(TPSUtil.rawTT20(ticks, tpsMultiplier, resourceLocation));
        Integer customTickCap = TickAccelerate.config.getCustomTickCap(resourceLocation);
        if (customTickCap != null && customTickCap > 0) {
            newTicks = Math.min(newTicks, customTickCap);
        }
        if (limitZero) {
            return newTicks > 0 ? newTicks : 1;
        }
        return newTicks;
    }

    public static double tt20(double ticks, boolean limitZero, double tpsMultiplier, @Nullable ResourceLocation resourceLocation) {
        double newTicks = TPSUtil.rawTT20(ticks, tpsMultiplier, resourceLocation);
        Integer customTickCap = TickAccelerate.config.getCustomTickCap(resourceLocation);
        if (customTickCap != null && customTickCap > 0) {
            newTicks = Math.min(newTicks, (double)customTickCap.intValue());
        }
        if (limitZero) {
            return newTicks > 0.0 ? newTicks : 1.0;
        }
        return newTicks;
    }

    public static double rawTT20(double ticks, double tpsMultiplier, @Nullable ResourceLocation resourceLocation) {
        Double customMultiplier = TickAccelerate.config.getCustomTpsMultiplier(resourceLocation);
        if (customMultiplier != null) {
            tpsMultiplier = customMultiplier;
        }
        if (ticks == 0.0 || tpsMultiplier == 0.0) {
            return 0.0;
        }
        return ticks / tpsMultiplier;
    }
}

